from passport.backend.core.conf import settings
from passport.backend.core.geobase import Region


def is_ip_blacklisted(ip):
    region = Region(ip=ip)
    return bool(region.AS_list and set(region.AS_list) & settings.BLACKLISTED_AS_LIST)


def get_ip_autonomous_system(ip):
    region = Region(ip=ip)
    return region.AS_list[0] if region.AS_list else None
