# -*- coding: utf-8 -*-
from passport.backend.core.logbroker.logbroker import LogbrokerWriterProto
from passport.backend.core.logging_utils.request_id import get_request_id


class ApiLogbrokerWriterProto(LogbrokerWriterProto):
    def _update_header(self, header):
        request_id = get_request_id()
        if request_id:
            header.passport_api.request_id_string = request_id


def get_api_logbroker_writer(name):
    # type: (str) -> ApiLogbrokerWriterProto
    return ApiLogbrokerWriterProto(name)
