# -*- coding: utf-8 -*-

import logging

from passport.backend.core.conf import settings
from passport.backend.core.mailer import (
    Attachment,
    PlainTextWithMixedAttachmentMessage,
)
from passport.backend.core.mailer.utils import render_message_text
from werkzeug.utils import secure_filename

from .common import extract_tld


log = logging.getLogger('passport.api.common.mail')


def create_semi_auto_message(context, photo_file, host, request_source, app_id):
    body = render_message_text('mail/semi_auto_otrs_message_body.txt', context).strip()
    attachments = []
    if photo_file:
        attachments.append(Attachment(
            secure_filename(photo_file.filename),
            'application/octet-stream',
            data=photo_file.stream.read(),
        ))

    target_email = settings.RESTORE_NOT_PASSED_ADDRESS
    if context['check_passed']:
        # Определяем TLD по хосту, отправляем письмо в соответствующий саппорт
        tld = extract_tld(host, settings.PASSPORT_TLDS) or settings.PASSPORT_DEFAULT_TLD
        target_email = settings.RESTORE_OTRS_ADDRESSES[tld]

    extra_headers = {
        'X-Address': context['user_ip'],
        'X-OTRS-Pass-Login': context['login'],
        'X-OTRS-fromfeedback': 'fio-%s' % request_source,
    }
    if app_id is not None:
        extra_headers['X-AppID'] = app_id

    return PlainTextWithMixedAttachmentMessage(
        subject=context['subject'],
        recipients=[target_email],
        body=body,
        from_=context['contact_email'],
        sender='restore@passport.yandex.ru',
        reply_to=context['contact_email'],
        attachments=attachments,
        extra_headers=extra_headers,
    )


def is_mail_occupied_by_another_user(blackbox, account):
    # вызывается при подписки на 2й сид чтоб удостоверится, что не будет перехвачено управление другим почтовым ящиком
    login_to_check = account.mail_alias.alias if account.mail_alias else account.login
    response = blackbox.userinfo(sid=2, login=login_to_check)
    if response['uid'] == account.uid or response['uid'] is None:
        return False
    return True
