# -*- coding: utf-8 -*-
# TODO: возможно, стоит унести в Core
from passport.backend.core.builders.mail_apis import (
    BaseCollieError,
    BaseFuritaError,
    BaseRPOPError,
    BaseWMIError,
    get_collie,
    get_furita,
    get_rpop,
    get_wmi,
)
from passport.backend.utils.common import unique_preserve_order


def get_user_email_folders(uid, suid, mdb):
    """
    Получить пользовательские папки в Почте.
    """
    try:
        wmi = get_wmi()
        response = wmi.folders(uid, suid, mdb)
        email_folders = unique_preserve_order(
            [folder['name'] for _, folder in response['folders'].items() if folder['isUser']],
        )
        return True, email_folders
    except BaseWMIError:
        return False, []


def get_blackwhite_lists(uid):
    """
    Получить почтовые черно-белые списки.
    """
    try:
        furita = get_furita()
        response = furita.blackwhite(uid)
        return True, response['blacklist'], response['whitelist']
    except BaseFuritaError:
        return False, [], []


def get_collectors(suid, mdb):
    """
    Получить почтовые сборщики.
    """
    try:
        rpop = get_rpop()
        response = rpop.list(suid, mdb)
        collectors = [
            item['email']
            for item in response['rpops']
        ]
        return True, collectors
    except BaseRPOPError:
        return False, []


def get_outbound_emails(uid):
    """
    Получить email-адреса, с которыми пользователь вел переписку.
    """
    try:
        collie = get_collie()
        contacts = collie.search_contacts(uid)
        emails = []
        for contact in contacts:
            for item in contact.get('vcard', {}).get('emails', []):
                emails.append(item['email'])
        return True, emails
    except BaseCollieError:
        return False, []
