# -*- coding: utf-8 -*-
from passport.backend.core.builders.oauth import (
    BaseOAuthError,
    get_oauth,
)
from passport.backend.utils.time import (
    datetime_to_integer_unixtime_nullable,
    parse_datetime,
)


def get_token_by_uid(application, uid, user_ip):
    try:
        oauth_response = get_oauth().token_by_uid(
            application['client_id'],
            application['client_secret'],
            uid,
            user_ip,
        )
        return True, oauth_response.get('access_token'), oauth_response.get('error')
    except BaseOAuthError:
        return False, None, None


def get_token_issue_time(oauth_info):
    return datetime_to_integer_unixtime_nullable(parse_datetime(
        oauth_info.get('issue_time') or oauth_info.get('ctime'),
    )) or 0
