# -*- coding: utf-8 -*-
import logging

from passport.backend.core.builders.kolmogor import BaseKolmogorError
from passport.backend.core.conf import settings
from passport.backend.core.logging_utils.loggers import GraphiteLogger


KOLMOGOR_COUNTER_SESSIONS_CREATED = 'sessions_created'
KOLMOGOR_COUNTER_CALLS_FAILED = 'calls_failed'
KOLMOGOR_COUNTER_CALLS_SHUT_DOWN_FLAG = 'calls_shut_down'


log = logging.getLogger(__name__)


def octopus_log_status(status):
    GraphiteLogger(service='octopus-calls').log(call_status=status)


def inc_sessions_created(kolmogor):
    octopus_log_status('sessions_created')
    try:
        kolmogor.inc(
            space=settings.KOLMOGOR_KEYSPACE_OCTOPUS_CALLS_COUNTERS,
            keys=[KOLMOGOR_COUNTER_SESSIONS_CREATED],
        )
    except BaseKolmogorError:
        log.warning('Request to Kolmogor failed while incrementing total sessions count')


def inc_calls_counter(kolmogor, call_counter_key):
    octopus_log_status(call_counter_key)
    try:
        kolmogor.inc(
            space=settings.KOLMOGOR_KEYSPACE_OCTOPUS_CALLS_COUNTERS,
            keys=[call_counter_key],
        )
    except BaseKolmogorError:
        log.warning('Request to Kolmogor failed while incrementing counter: %s', call_counter_key)
