# -*- coding: utf-8 -*-
from passport.backend.core.builders.blackbox import get_blackbox
from passport.backend.core.conf import settings


def does_domain_belong_to_pdd(login_or_domain):
    if '@' in login_or_domain:
        _, domain = login_or_domain.rsplit('@', 1)
    else:
        domain = login_or_domain

    domains = get_blackbox().hosted_domains(domain=domain.strip())
    return bool(domains['hosted_domains'])


def is_domain_suitable_for_directory(domain):
    """
    Домен Директории представляет собой <subdomain>.<domain>, где domain - домен из списка разрешённых,
    а subdomain - поддомен, введённый пользователем
    """
    domain = domain.lower()

    if '.' not in domain:
        return False

    subdomain, upper_level_domain = domain.split('.', 1)
    if upper_level_domain not in settings.DOMAINS_USED_BY_DIRECTORY:
        return False

    if subdomain in settings.RESTRICTED_DIRECTORY_SUBDOMAINS:
        return False

    return True
