# -*- coding: utf-8 -*-
from passport.backend.core.conf import settings
from passport.backend.core.types.mobile_device_info import normalize_app_id


def get_phonish_namespace(app_id):
    app_id = normalize_app_id(app_id)
    return settings.APP_ID_TO_PHONISH_NAMESPACE.get(
        app_id,
        settings.PHONISH_NAMESPACE_DEFAULT,
    )


__all__ = (
    'get_phonish_namespace',
)
