# -*- coding: utf-8 -*-

import logging

from passport.backend.core.tracks.track_manager import TrackManager


log = logging.getLogger('passport.api.common.processes')

PROCESS_RESTORE = 'restore'
PROCESS_LOGIN_RESTORE = 'login_restore'
PROCESS_WEB_REGISTRATION = 'web_registration'
PROCESS_YAKEY_BACKUP = 'yakey_backup'
PROCESS_ACCOUNT_DELETE_V2 = 'account_delete_v2_process'
PROCESS_AUTH_BY_SMS = 'auth_by_sms'
PROCESS_VOLUNTARY_PASSWORD_CHANGE = 'voluntary_password_change'
PROCESS_FORWARD_AUTH_TO_MOBILE_BY_TRACK = 'forward_auth_to_mobile_by_track'

ALL_PROCESSES = {
    PROCESS_RESTORE,
    PROCESS_LOGIN_RESTORE,
    PROCESS_WEB_REGISTRATION,
    PROCESS_YAKEY_BACKUP,
    PROCESS_ACCOUNT_DELETE_V2,
    PROCESS_AUTH_BY_SMS,
    PROCESS_VOLUNTARY_PASSWORD_CHANGE,
    PROCESS_FORWARD_AUTH_TO_MOBILE_BY_TRACK,
}


def is_process_allowed(allowed_processes, is_process_required=False, track_id=None, track=None):
    """
    Проверяет, что доступ к API разрешен для записанного в треке процесса.
    @param allowed_processes: список имен процессов, которым разрешен доступ к API
    @param is_process_required: признак того, что имя процесса обязательно должно быть задано в треке
    @param track_id: ID трека обращающегося процесса
    @param track: трек обращающегося процесса
    """
    if not track and not track_id:
        # проверить права доступа процесса к API можно только при наличии трека
        return True
    if track_id and not track:
        track = TrackManager().read(track_id)
    process_name = track.process_name
    if is_process_required and not process_name:
        log.warning('Process is required and not present in track')
        return False
    elif not process_name:
        return True
    # имя процесса задано - это означает, что процесс в треке обязательно должен быть в списке разрешенных,
    # даже если список пуст
    if process_name in allowed_processes:
        return True

    log.warning('Process "%s" is not allowed to use this API method', process_name)
    return False


__all__ = [
    'ALL_PROCESSES',
    'is_process_allowed',
    'PROCESS_RESTORE',
    'PROCESS_LOGIN_RESTORE',
    'PROCESS_WEB_REGISTRATION',
    'PROCESS_YAKEY_BACKUP',
    'PROCESS_ACCOUNT_DELETE_V2',
    'PROCESS_AUTH_BY_SMS',
    'PROCESS_VOLUNTARY_PASSWORD_CHANGE',
    'PROCESS_FORWARD_AUTH_TO_MOBILE_BY_TRACK',
]
