# -*- coding: utf-8 -*-
import logging

from flask import request
from passport.backend.api.common.auth_challenge import write_profile_to_log
from passport.backend.api.common.profile.utils import extract_mobile_params_from_track
from passport.backend.core.conf import settings
from passport.backend.core.env_profile.loader import load_ufo_profile


log = logging.getLogger('passport.api.common.profile')


def process_env_profile(account, track, ufo_profile=None, env=None):
    """
    Создаёт профиль текущего окружения, обновляет коллекцию профилей аккаунта.
    """
    if not settings.AUTH_PROFILE_ENABLED:
        return

    is_mobile = bool(track and (track.x_token_client_id or track.device_id))
    ext_params = dict()

    if env is None:
        env = request.env
    if is_mobile and track is not None:
        ext_params = extract_mobile_params_from_track(track)
    profile = env.make_profile(is_mobile=is_mobile, mobile_params=ext_params)

    if not ufo_profile:
        _, __, ufo_profile = load_ufo_profile(account.uid, account.global_logout_datetime)
    result = ufo_profile.process_new_profile(profile)

    if result.WRITE_TO_STORAGE:
        write_profile_to_log(account.uid, result.profile)
