# -*- coding: utf-8 -*-
from passport.backend.core.conf import settings


def get_suggested_webauthn_credentials(account, env):
    user_agent_info = env.user_agent_info
    current_browser_id = settings.BROWSER_ENCODE.get(user_agent_info.get('BrowserName')) or None
    current_os_family_id = settings.OS_FAMILY_ENCODE.get(user_agent_info.get('OSFamily')) or None

    cred_id_from_cookie = env.cookies.get('wcid')

    return [
        cred
        for cred in account.webauthn_credentials.all()
        if (
            cred.is_suitable_for_host(env.host) and
            (
                cred.external_id == cred_id_from_cookie or
                (cred.browser_id == current_browser_id and cred.os_family_id == current_os_family_id)
            )
        )
    ]
