# -*- coding: utf-8 -*-

import uuid

from passport.backend.core.conf import settings
from passport.backend.core.logging_utils.loggers.statbox import YasmsPrivateLogger
from passport.backend.core.types.mobile_device_info import get_app_id_from_track
from passport.backend.core.utils.experiments import is_experiment_enabled
from passport.backend.utils.time import get_unixtime


def build_route_advice(number, consumer, track=None, route=None):
    """
    Получить значение route для вызова send_sms.
    """
    if route:
        return route

    if consumer in settings.CONSUMER_TO_SMS_ROUTE:
        return settings.CONSUMER_TO_SMS_ROUTE[consumer]

    app_id = get_app_id_from_track(track)
    if app_id in settings.APP_ID_TO_SMS_ROUTE:
        if is_experiment_enabled(number.digital, settings.APP_ID_SPECIFIC_ROUTE_DENOMINATOR):
            return settings.APP_ID_TO_SMS_ROUTE[app_id]

    return 'validate'


def _generate_fake_global_sms_id():
    # этот метод мокается в тестах
    return 'fake-{}'.format(uuid.uuid4().get_hex())


def generate_fake_global_sms_id():
    return _generate_fake_global_sms_id()


def log_sms_not_delivered(reason, number, global_sms_id, caller, client_ip, user_agent):
    logger = YasmsPrivateLogger()
    common_params = dict(
        sender='passport',
        number=number.e164,
        rule='fraud',
        identity=reason,
        user_ip=client_ip,
        user_agent=user_agent,
        global_smsid=global_sms_id,
        caller=caller,
    )
    logger.log(
        action='enqueued',
        **common_params
    )
    logger.log(
        action='notdeliveredtosmsc',
        **common_params
    )
