# -*- coding: utf-8 -*-
import os
import re
import socket

from passport.backend.library.configurator import Configurator
import psutil
import yenv


PLUS_HOSTNAME_RE = re.compile(r'^passport-api-[misfv][0-9]\.passport\.yandex\.net$')


def is_plus_instance():
    return yenv.type not in ('development', 'rc', 'testing') and PLUS_HOSTNAME_RE.match(socket.getfqdn()) is not None


def is_debug():
    current_user = os.environ.get('USER', os.environ.get('LOGNAME', 'root'))
    return yenv.type == 'development' and current_user not in ('root', 'www-data')


def is_docker():
    current_user = os.environ.get('USER', os.environ.get('LOGNAME', 'root'))
    return yenv.type == 'development' and current_user == 'docker_dev'


config = Configurator(
    'passport-api',
    configs=[
        {'yenv': {'type': yenv.type}},
        'base.yaml',
        '%s.yaml' % yenv.type,
        'plus.yaml' if is_plus_instance() else {},
        'devserver.yaml' if is_debug() else {},
        'docker.yaml' if is_docker() else {},
    ],
)

workers_by_threads = config.get('application', {}).get('workers_by_threads')
if workers_by_threads:
    n_cpu = psutil.cpu_count()
    workers = workers_by_threads.get(n_cpu, workers_by_threads.get('default'))
    if workers is not None:
        config['application']['workers'] = workers
