# -*- coding: utf-8 -*-

from passport.backend.api.views.bundle.exceptions import (
    BaseBundleError,
    EmailLimitPerProfileReachedError,
)


class EmailValidatorError(BaseBundleError):
    pass


class EmailGenericError(EmailValidatorError):
    error = 'email.generic_error'


class EmailIsNativeError(EmailValidatorError):
    error = 'email.is_native'

    def __init__(self, address):
        self.message = u'Address %s valid as native.' % address
        super(EmailIsNativeError, self).__init__()


class EmailGrantsError(EmailValidatorError):
    error = 'email.no_grants'

    def __init__(self, missing_grants):
        self.missing = ', '.join(missing_grants)
        super(EmailGrantsError, self).__init__()


class EmailAlreadyConfirmedError(EmailValidatorError):
    error = 'email.already_confirmed'

    def __init__(self, address, uid, code):
        self.message = code
        self.address = address
        self.uid = uid
        super(EmailAlreadyConfirmedError, self).__init__()


class EmailIncorrectKeyError(EmailValidatorError):
    error = 'email.incorrect_key'

    def __init__(self, uid, code):
        self.uid = uid
        self.message = code
        super(EmailIncorrectKeyError, self).__init__()


class EmailIsNotUnsafeError(EmailValidatorError):
    error = 'email.not_unsafe'

    def __init__(self, address, uid):
        self.uid = uid
        self.address = address
        self.message = u'Address "%s" is not unsafe.' % address
        super(EmailIsNotUnsafeError, self).__init__()


class EmailIsNotRpopError(EmailValidatorError):
    error = 'email.not_rpop'

    def __init__(self, address, uid):
        self.uid = uid
        self.address = address
        self.message = u'Address "%s" is not rpop.' % address
        super(EmailIsNotRpopError, self).__init__()


class EmailAlreadySentError(EmailValidatorError):
    error = 'email.already_sent'

    def __init__(self, address):
        self.address = address
        # В старом валидаторе этот параметр хранил количество минут,
        # через которое можно попробовать послать письмо ещё раз.
        # Новая реализация не позволяет выдать точное время, поэтому
        # выставляем наибольшее возможное время.
        setattr(self, 'retry-in', '15')
        super(EmailAlreadySentError, self).__init__()
