# -*- coding: utf-8 -*-

from passport.backend.api.settings.domain_keyspaces import PASSPORT_TLDS
from passport.backend.core import validators


class AddRPOPForm(validators.Schema):
    uid = validators.Uid()
    email = validators.ComprehensiveEmailValidator()


class GetConfirmationCodeForm(validators.Schema):
    uid = validators.Uid(if_missing=None)
    sessionid = validators.String(if_missing=None)
    email = validators.ComprehensiveEmailValidator()
    host = validators.String(if_missing=None)
    unsafe = validators.StringBool(if_missing=True)

    chained_validators = [
        validators.RequireSet(
            [
                ('uid', 'email'),
                ('sessionid', 'host', 'email'),
            ],
        ),
    ]


class ConfirmEmailByCodeForm(validators.Schema):
    uid = validators.Uid(if_missing=None)
    sessionid = validators.String(if_missing=None)
    host = validators.String(if_missing=None)
    unsafe = validators.StringBool(if_missing=True)
    key = validators.String(not_empty=True)

    chained_validators = [
        validators.RequireSet(
            [
                ('uid', 'key'),
                ('sessionid', 'host', 'key'),
            ],
        ),
    ]


class DeleteEmailForm(validators.Schema):
    uid = validators.Uid()
    email = validators.ComprehensiveEmailValidator()


class DeleteUnsafeForm(validators.Schema):
    uid = validators.Uid()
    email = validators.ComprehensiveEmailValidator()


class DeleteRpopForm(validators.Schema):
    uid = validators.Uid()
    email = validators.ComprehensiveEmailValidator()


class DeleteAllEmailsForm(validators.Schema):
    sessionid = validators.String()
    host = validators.String()


class ValidateByEmailForm(validators.Schema):
    uid = validators.Uid(if_missing=None)
    sessionid = validators.String(if_missing=None)
    host = validators.String(if_missing=None)
    email = validators.ComprehensiveEmailValidator()
    force = validators.StringBool(if_missing=False)

    lang = validators.PortalLanguage(if_missing=None)
    domain = validators.OneOf(
        PASSPORT_TLDS,
        if_missing=None,
    )
    retpath = validators.RetPath(if_missing=None)

    chained_validators = [
        validators.RequireSet(
            [
                ('uid', 'email'),
                ('sessionid', 'host', 'email'),
            ],
        ),
    ]
