# -*- coding: utf-8 -*-

from passport.backend.core.conf import settings


class BaseApiError(Exception):
    code = None
    status = 400
    message = None


class UserNotVerifiedError(BaseApiError):
    """Пользователь не прошел проверку ни через телефон, ни через капчу"""
    code = 'UserNotVerifiedError'
    message = 'User was not verified'


class UnknownLoginError(BaseApiError):
    """Не найден пользователь по логину"""


class EulaIsNotAcceptedError(BaseApiError):
    """Пользователь не принял пользовательское соглашение при регистрации"""
    code = 'EulaIsNotAcceptedError'
    message = 'Eula is not accepted'


class MissingHeaderError(BaseApiError):
    """Не найден необходимый заголовок"""


class InvalidHostError(BaseApiError):
    """Значение Ya-Client-Host невалидно"""
    code = 'YaClientHostIsInvalid'
    message = 'YaClientHost header is invalid'


class RegistrationAlreadyCompletedError(BaseApiError):
    """Трэк повторно используется для регистрации"""
    code = 'RegistrationAlreadyCompletedError'
    message = 'Repeated usage of the same track for registration'


class AccountAlreadyCompletedError(BaseApiError):
    """Пользователь уже прошел пострегистрацию"""
    code = 'AccountAlreadyCompletedError'
    message = 'Account is a portal account already'


class AccountNotRegisteredError(BaseApiError):
    """Пользователь еще не прошел регистрацию"""
    code = 'AccountNotRegisteredError'
    message = 'Account was not registered on this track yet'


class UnknownAlternativeRegistrationTypeError(BaseApiError):
    """Неизвестный тип альтернативной регистрации"""
    status = 500
    code = 'UnknownAlternativeRegistrationTypeError'
    message = 'Unknown alternative registration type'


class SessionAlreadyCreatedError(BaseApiError):
    """Сессию уже создали для данного трека"""
    code = 'SessionAlreadyCreatedError'
    message = 'Session already created for this account'


class SessionOverflowError(BaseApiError):
    """Пытаемся доавторизовать в куку больше пользователей, чем это разрешено"""
    code = 'SessionOverflowError'
    message = 'No more users allowed'


class SessionExpiredError(BaseApiError):
    """При вызове editsession оказалось, что сессия уже недействительна"""
    code = 'SessionExpiredError'
    message = 'This session has expired'


class InvalidIpError(BaseApiError):
    """вызов с неправильного ip"""
    code = 'InvalidIpError'
    message = 'This ip is not valid'


class OAuthTokenAlreadyCreatedError(BaseApiError):
    """OAuth-токен уже создали для данного трека"""
    code = 'OAuthTokenAlreadyCreated'
    message = 'OAuth token already created for this account'


class OAuthTokenNotFoundError(BaseApiError):
    """Не найден токен в ответе от OAuth"""
    status = 503
    code = 'OAuthTokenNotFound'
    message = 'OAuth token not found in OAuth response'


class SuggestKiddishLoginError(BaseApiError):
    """Не удалось сгенерировать ребёнкишный логин"""


class SuggestKolonkishLoginError(BaseApiError):
    """Не удалось сгенерировать колонкишный логин"""


class SuggestSocialLoginError(BaseApiError):
    """Невозможно сгенерировать социальный логин"""


class SuggestPhonishLoginError(BaseApiError):
    """Не удалось сгенерировать фонишный логин"""


class SuggestNeohonishLoginError(BaseApiError):
    """Не удалось сгенерировать неофонишный логин"""


class SuggestYambotLoginError(BaseApiError):
    """Не удалось сгенерировать логин для бота Yamb"""


class PhoneBaseError(BaseApiError):
    """Базовый класс ошибок работы с телефоном"""


class PhoneConfirmationError(PhoneBaseError):
    """Базовый класс ошибок валидации телефона"""
    code = 'PhoneConfirmationError'


class SmsNotSentError(PhoneConfirmationError):
    """Смс не отправлялась"""
    code = 'SmsNotSent'
    message = 'Validation code was not generated and sent'


class PhoneAlreadyConfirmedError(PhoneConfirmationError):
    """Телефон уже подтвержден"""
    code = 'PhoneAlreadyConfirmed'
    message = 'Phone has been confirmed already'


class ConfirmationsLimitExceededError(PhoneConfirmationError):
    """Превышено количество ввода кода подтверждения"""
    code = 'ConfirmationsLimitExceeded'
    message = 'Fail confirm limit exceeded'


class SmsSendLimitExceededError(PhoneConfirmationError):
    """Превышено количество отправок смс для подтверждения телефона"""
    code = 'SmsSendLimitExceeded'
    message = 'Resend reached sms limit'


class RegistrationSmsSendPerIPLimitExceededError(PhoneConfirmationError):
    """Превышено количество отправок смс для подтверждения телефона для одного ip-адреса в процессе регистрации"""
    code = 'RegistrationSmsSendPerIPLimitExceeded'
    message = 'Reached limit for sms per ip in registration'


class SmsSendTooEarlyError(PhoneConfirmationError):
    """Переотправка смс вызвана слишком рано"""
    message = "Can't resend sms earlier than %d seconds from previous sending" % settings.SMS_VALIDATION_RESEND_TIMEOUT
    code = 'SmsSendTooEarly'


class BindLimitExceededError(PhoneConfirmationError):
    """Телефон привязан к максимально доступному числу пользователей"""
    code = 'BindLimitExceeded'
    message = 'This phone reached bind limit'


class PhoneCopyError(PhoneBaseError):
    code = 'PhoneCopyError'


class InvalidSrcOAuthTokenError(PhoneCopyError):
    """Невалидный токен пользователя с которого копируют телефон"""
    code = 'InvalidSrcOAuthToken'
    message = 'Source OAuth token is invalid'


class InvalidDstOAuthTokenError(PhoneCopyError):
    """Невалидный токен пользователя которому копируют телефон"""
    code = 'InvalidDstOAuthToken'
    message = 'Destination OAuth token is invalid'


class SrcAndDstUidEqualError(PhoneCopyError):
    """Пользователи совпадают при копировании телефона"""
    code = 'SrcAndDstUidEqual'
    message = 'Source and destination users have same uid'


class PhoneNotFoundError(PhoneBaseError):
    """Телефон не найден у пользователя с которого копируют телефон"""
    code = 'PhoneNotFound'
    message = 'Phone not found'


class PhoneNotConfirmedError(PhoneBaseError):
    """Телефон не подтвержден"""
    code = 'PhoneNotConfirmed'
    message = 'Phone is not confirmed'


class InvalidOAuthTokenError(BaseApiError):
    """Невалидный oauth-токен"""
    code = 'InvalidOAuthToken'
    message = 'OAuth token is invalid'


class InvalidOAuthScopeError(BaseApiError):
    """Невалидный oauth scope"""
    code = 'InvalidOAuthScope'
    message = 'OAuth scope is invalid'


class InvalidTrackTypeError(BaseApiError):
    """Неверный тип трека для данной операции"""
    code = 'InvalidTrackType'
    message = 'Track type is invalid'


class InvalidTrackStateError(BaseApiError):
    """
    Пользователь пришел в ручку с неверным треком:
    не прошел необходимый шаг или повторно с "отработанным" треком в ту же
    """
    code = 'InvalidTrackState'
    message = 'Track state is invalid'


class AuthorizationNotAllowedError(BaseApiError):
    """Невозможна авторизация для данного трека"""
    code = 'AuthorizationNotAllowed'
    message = 'Authorization is not allowed for this track'


class EmptyCaptchaKeyError(BaseApiError):
    """Не указан ключ для капчи ни в запросе, ни в треке"""
    code = 'EmptyCaptchaKey'
    message = 'Captcha key not provided'


class AccountGlobalLogoutError(BaseApiError):
    """Был произведен глобальный выход на аккаунте"""
    code = 'AccountGlobalLogout'
    message = 'User was logged out globally'


class DomainAlreadyExistsError(BaseApiError):
    """Создаваемый ПДД-домен уже существует"""
    code = 'DomainAlreadyExists'
    message = 'PDD-domain already exists'


class DomainInvalidTypeError(BaseApiError):
    """Домен не подходит для выбранной операции"""
    code = 'DomainInvalidType'
    message = 'Domain not applicable for current operation'


class AccountDisabledError(BaseApiError):
    """
    Аккаунт заблокирован.
    """
    code = 'AccountDisabled'
    message = 'Account is disabled'
