# -*- coding: utf-8 -*-

from passport.backend.core import validators


class ConsumerForm(validators.Schema):
    consumer = validators.Consumer()


class UidForm(ConsumerForm):
    uid = validators.Uid()


class TrackedConsumerForm(ConsumerForm):
    track_id = validators.TrackId(if_missing=None)


class RequiredTrackedConsumerForm(ConsumerForm):
    track_id = validators.TrackId(not_empty=True)


class RequiredUidTrackedConsumerForm(UidForm):
    track_id = validators.TrackId(not_empty=True)


class SocialProvider(RequiredTrackedConsumerForm):
    provider = validators.SocialProvider(not_empty=True)


class SetPassword(RequiredTrackedConsumerForm):
    password = validators.String(not_empty=True)


class DeviceInfoForm(validators.Schema):
    am_version = validators.String(if_missing=None, strip=True)
    am_version_name = validators.String(if_missing=None, strip=True)
    app_id = validators.String(if_missing=None, strip=True)
    app_platform = validators.String(if_missing=None, strip=True)
    app_version = validators.String(if_missing=None, strip=True)
    app_version_name = validators.String(if_missing=None, strip=True)
    manufacturer = validators.String(if_missing=None, strip=True)
    model = validators.String(if_missing=None, strip=True)
    uuid = validators.String(if_missing=None, strip=True)
    device_name = validators.String(if_missing=None, strip=True)
    os_version = validators.String(if_missing=None, strip=True)
    # Идентификатор устройства для iPhone'а передаётся из АМа
    ifv = validators.String(if_missing=None, strip=True)
    # Идентификатор устройства для Android'а передаётся из АМа
    deviceid = validators.String(if_missing=None, strip=True)
    # Идентификатор устройства
    device_id = validators.String(if_missing=None, strip=True)

    DEVICE_INFO_FIELD_NAMES = (
        'am_version',
        'am_version_name',
        'app_id',
        'app_platform',
        'manufacturer',
        'model',
        'app_version',
        'app_version_name',
        'uuid',
        'deviceid',
        'ifv',
        'device_name',
        'os_version',
        'device_id',
    )


__all__ = (
    'ConsumerForm',
    'DeviceInfoForm',
    'UidForm',
    'TrackedConsumerForm',
    'RequiredTrackedConsumerForm',
    'RequiredUidTrackedConsumerForm',
    'SocialProvider',
    'SetPassword',
)
