# -*- coding: utf-8 -*-

from passport.backend.core import validators

from .base import (
    RequiredTrackedConsumerForm,
    TrackedConsumerForm,
)


class CaptchaGenerateForm(TrackedConsumerForm):
    display_language = validators.CaptchaDisplayLanguage(if_missing=None)
    country = validators.CountryCode(if_missing=None)
    checks = validators.CaptchaChecks()
    voice = validators.StringBool(if_missing=False, not_empty=True)
    use_cached = validators.StringBool(if_missing=False, not_empty=True)
    scale_factor = validators.Number(if_missing=None)
    type = validators.OneOf(['wave'], if_missing=None)

    chained_validators = [
        validators.RequireSome([
            'display_language',
            'country',
        ], min_=1, max_=1),
    ]


class CaptchaCheckForm(RequiredTrackedConsumerForm):
    answer = validators.String(not_empty=True, max=100)
    key = validators.String(if_missing=None, max=100)


__all__ = (
    'CaptchaGenerateForm',
    'CaptchaCheckForm',
)
