# -*- coding: utf-8 -*-

from passport.backend.core import validators


class Hint(validators.Schema):
    display_language = validators.DisplayLanguage()

    hint_question_id = validators.HintQuestionId()
    hint_question = validators.HintQuestion()
    hint_answer = validators.HintAnswer(if_missing=None)

    chained_validators = [
        validators.RequireSet(
            allowed_sets=[
                ['hint_question_id', 'hint_answer'],
                ['hint_question', 'hint_answer'],
            ],
        ),
    ]


__all__ = (
    'Hint',
)
