# -*- coding: utf-8 -*-

from passport.backend.core import validators

from .base import UidForm


class AccountPhone(UidForm):
    phone_number = validators.String(not_empty=True)
    confirmation_timestamp = validators.Int(if_missing=None)

    chained_validators = [
        validators.PhoneNumber(allow_impossible=True)
    ]


__all__ = ('AccountPhone',)
