# -*- coding: utf-8 -*-

from passport.backend.core import validators

from .base import (
    ConsumerForm,
    RequiredTrackedConsumerForm,
)


class PhoneConfirmation(RequiredTrackedConsumerForm):

    # TODO: Заменить валидаторы языка капчи, КВ, смсок на один валидатор
    display_language = validators.DisplayLanguage(not_empty=True)
    country = validators.CountryCode(not_empty=True)
    phone_number = validators.String(not_empty=True)
    ignore_phone_compare = validators.StringBool(if_missing=False, not_empty=True)


class PhoneCopy(ConsumerForm):
    src_oauth_token = validators.String(not_empty=True)
    dst_oauth_token = validators.String(not_empty=True)
    phone_number = validators.String(not_empty=True)

    chained_validators = [
        validators.PhoneNumber(allow_impossible=True)
    ]


class ConfirmPhone(RequiredTrackedConsumerForm):
    code = validators.String(not_empty=True, strip=True)


__all__ = (
    'PhoneConfirmation',
    'PhoneCopy',
    'ConfirmPhone',
)
