# -*- coding: utf-8 -*-

from passport.backend.api.validators import FieldOnlyForSids
from passport.backend.core import validators

from .base import UidForm


class Subscription(UidForm):
    service = validators.Service()
    login_rule = validators.Int(if_missing=None)
    wmode = validators.Int(if_missing=None)
    yastaff_login = validators.String(if_missing=None, not_empty=True, strip=True)

    chained_validators = [
        # так как sid - целое, а slug - строка,
        # то приходится это учитывать в списке сидов валидатора FieldOnlyForSids
        FieldOnlyForSids('wmode', [42]),
        FieldOnlyForSids('yastaff_login', [669]),
    ]


class DeleteSubscription(UidForm):
    service = validators.Service()


__all__ = ('Subscription', 'DeleteSubscription',)
