# -*- coding: utf-8 -*-

from passport.backend.core import validators

from .base import TrackedConsumerForm


class SuggestLogin(TrackedConsumerForm):
    login = validators.String(if_missing=None, not_empty=True, strip=True)
    firstname = validators.FirstName(if_missing=None, not_empty=True)
    lastname = validators.LastName(if_missing=None, not_empty=True)
    language = validators.PortalLanguage(if_missing=None, not_empty=True)

    phone_number = validators.String(if_missing=None, not_empty=True)

    chained_validators = [
        validators.RequireSet(allowed_sets=[
            ['firstname', 'lastname', 'login'],
            ['firstname', 'lastname'],
            ['login'],
        ]),
        validators.PhoneNumber(),
    ]


class SuggestGender(TrackedConsumerForm):
    name = validators.String(if_missing=None, not_empty=True)
    firstname = validators.FirstName(if_missing=None, not_empty=True)
    lastname = validators.LastName(if_missing=None, not_empty=True)

    chained_validators = [
        validators.RequireSet(allowed_sets=[
            ['firstname', 'lastname'],
            ['firstname'],
            ['lastname'],
            ['name'],
        ]),
    ]


class SuggestName(TrackedConsumerForm):
    name = validators.String(not_empty=True)


class ControlQuestions(TrackedConsumerForm):
    display_language = validators.DisplayLanguage()


__all__ = (
    'SuggestLogin',
    'SuggestGender',
    'SuggestName',
    'ControlQuestions',
)
