# -*- coding: utf-8 -*-

from passport.backend.api.common.processes import ALL_PROCESSES
from passport.backend.core import validators
from passport.backend.core.conf import settings
from passport.backend.core.tracks.model import TRACK_TYPES

from .base import (
    ConsumerForm,
    DeviceInfoForm,
)


class CreateTrackStartForm(ConsumerForm):
    filter_extra_fields = False

    track_type = validators.OneOf(
        # FIXME: PASSP-11574 Как только последние потребители account/social
        # смирятся с неизбежностью - оставить только TRACK_TYPES.
        list(TRACK_TYPES.keys()) + list(settings.DELETED_TRACK_TYPES),
        if_missing='register',
        not_empty=True,
    )

    process_name = validators.OneOf(
        ALL_PROCESSES,
        if_missing=None,
        not_empty=True,
    )


class TrackBaseForm(ConsumerForm):
    language = validators.PortalLanguage(if_missing=None, not_empty=False)
    display_language = validators.DisplayLanguage(if_missing=None, not_empty=False)
    country = validators.CountryCode(if_missing=None, not_empty=False)
    retpath = validators.RetPath(if_missing=None, not_empty=False)
    origin = validators.String(if_missing=None, not_empty=False, strip=True)
    service = validators.String(if_missing=None, not_empty=False, strip=True)
    frontend_state = validators.String(if_missing=None, not_empty=False, strip=True)
    scenario = validators.String(if_missing=None, not_empty=False, strip=True)
    js_fingerprint = validators.String(if_missing=None, not_empty=False, strip=True)

    # Во ФРОДО
    device_language_sys = validators.String(if_missing=None, not_empty=False, strip=True)
    device_locale = validators.String(if_missing=None, not_empty=False, strip=True)
    device_geo_coarse = validators.String(if_missing=None, not_empty=False, strip=True)
    device_hardware_id = validators.String(if_missing=None, not_empty=False, strip=True)
    device_os_id = validators.String(if_missing=None, not_empty=False, strip=True)
    device_application = validators.String(if_missing=None, not_empty=False, strip=True)
    device_cell_provider = validators.String(if_missing=None, not_empty=False, strip=True)
    device_hardware_model = validators.String(if_missing=None, not_empty=False, strip=True)
    device_clid = validators.String(if_missing=None, not_empty=False, strip=True)
    device_app_uuid = validators.String(if_missing=None, not_empty=False, strip=True)
    check_css_load = validators.StringBool(if_missing=None, not_empty=False, strip=True)
    check_js_load = validators.StringBool(if_missing=None, not_empty=False, strip=True)

TrackBaseForm.fields.update(DeviceInfoForm.fields)


class CreateRegisterTrackForm(TrackBaseForm):
    pass


class CreateCompleteTrackForm(TrackBaseForm):
    token = validators.String(not_empty=True)


class CreateOtherTrackForm(TrackBaseForm):
    pass


class SaveTrackForm(TrackBaseForm):
    track_id = validators.TrackId()
    # TODO: удалить как только фронтенд заиспользует check_css_load & check_js_load
    page_loading_info = validators.String(max=1024, if_missing=None)  # разумное ограничение на длину поля

    updatable_fields = [
        'language',
        'display_language',
        'country',
        'retpath',
        'origin',
        'service',
        'page_loading_info',
        'check_css_load',
        'check_js_load',
        'frontend_state',
        'scenario',
        'antifraud_external_id',
        'js_fingerprint',

        'device_language_sys',
        'device_locale',
        'device_geo_coarse',
        'device_hardware_id',
        'device_os_id',
        'device_application',
        'device_cell_provider',
        'device_hardware_model',
        'device_clid',
        'device_app_uuid',

        'app_id',
        'app_platform',
        'app_version',
        'manufacturer',
        'model',
        'uuid',
        'device_name',
        'os_version',
        'ifv',
        'deviceid',
        'device_id',
    ]

    chained_validators = [
        validators.RequireSome(updatable_fields, min_=1, max_=len(updatable_fields)),
    ]


__all__ = (
    'CreateRegisterTrackForm',
    'CreateCompleteTrackForm',
    'CreateTrackStartForm',
    'CreateOtherTrackForm',
    'SaveTrackForm',
)
