# -*- coding: utf-8 -*-

from passport.backend.core import validators

from .base import (
    RequiredTrackedConsumerForm,
    TrackedConsumerForm,
)


class SimpleLoginValidation(RequiredTrackedConsumerForm):
    login = validators.String(not_empty=True)
    ignore_stoplist = validators.StringBool(if_missing=False, not_empty=True)


class LoginValidation(validators.Schema):
    login = validators.Login()
    ignore_stoplist = validators.StringBool(if_missing=False, not_empty=True)

    chained_validators = [
        validators.Availability()
    ]


class SimplePasswordValidation(TrackedConsumerForm):
    password = validators.String(not_empty=True)
    login = validators.String(if_missing=None)
    policy = validators.PasswordPolicy(if_missing=None, not_empty=True)
    phone_number = validators.String(if_missing=None, not_empty=True)
    country = validators.CountryCode(if_missing=None)


class SimplePhoneNumberValidation(RequiredTrackedConsumerForm):
    country = validators.CountryCode(if_missing=None)
    phone_number = validators.String(not_empty=True)
    ignore_phone_compare = validators.StringBool(if_missing=False, not_empty=True)


class SimpleHintValidation(TrackedConsumerForm):
    hint_question_id = validators.String(if_missing=None)
    hint_question = validators.String(if_missing=None)
    hint_answer = validators.String(if_missing=None)

    chained_validators = [
        validators.RequireSome(min_=0, max_=1, some_fields=[
            'hint_question_id',
            'hint_question',
        ]),
        validators.RequireSome(min_=1, max_=2, some_fields=[
            'hint_answer',
            'hint_question_id',
            'hint_question',
        ]),
    ]


class RetPathValidation(TrackedConsumerForm):
    retpath = validators.String(not_empty=True)


__all__ = (
    'SimpleLoginValidation',
    'LoginValidation',
    'SimplePasswordValidation',
    'SimplePhoneNumberValidation',
    'SimpleHintValidation',
    'RetPathValidation',
)
