# -*- coding: utf-8 -*-

from passport.backend.core import validators
from passport.backend.core.services import get_service


class SetService(validators.FormValidator):
    """Заменяет sid и from на service = Service(sid, from)"""

    required = True

    def _to_python(self, value_dict, state):
        min_ = 1 if self.required else 0
        validators.RequireSome(['sid', 'from'], max_=2, min_=min_,
                               messages={'empty': u'недостаточно параметров'}).to_python(value_dict)

        new_value_dict = dict(value_dict)
        sid = value_dict['sid']
        from_ = value_dict['from']

        if sid is None and from_ is None:
            new_value_dict['service'] = None
            return new_value_dict

        service = get_service(sid=sid, slug=from_)

        new_value_dict['service'] = service
        new_value_dict['sid'] = service.sid
        new_value_dict['from'] = service.slug

        return new_value_dict
