# -*- coding: utf-8 -*-

from datetime import timedelta

import yenv


ACCOUNT_DELETER_PATH = '/usr/bin/account_deleter'

if yenv.type not in {'development', 'testing'}:     # pragma: no cover
    # PASSP-10606 Промежуток времени, которое логин удаленного пользователя
    # проведет в карантине.
    LOGIN_QUARANTINE_PERIOD = 3600 * 24 * 180
else:
    LOGIN_QUARANTINE_PERIOD = 3600

if yenv.type not in {'development', 'testing'}:     # pragma: no cover
    # Период, в течение которого аккаунт находится в карантине после удаления
        ACCOUNT_DELETION_QUARANTINE_PERIOD = timedelta(days=30)
else:
    ACCOUNT_DELETION_QUARANTINE_PERIOD = timedelta(minutes=30)

if yenv.type not in {'development', 'testing'}:     # pragma: no cover
    PHONE_SUITABLE_FOR_ACCOUNT_DELETION_SINCE_TIME = EMAIL_SUITABLE_FOR_ACCOUNT_DELETION_SINCE_TIME = timedelta(days=7)
else:
    PHONE_SUITABLE_FOR_ACCOUNT_DELETION_SINCE_TIME = EMAIL_SUITABLE_FOR_ACCOUNT_DELETION_SINCE_TIME = timedelta(minutes=10)

if yenv.type not in {'development', 'testing'}:     # pragma: no cover
    # Период, в течение которого возможно восстановление аккаунта, заблокированного при удалении
    # Оставляем запас, чтобы предотвратить одновременную модификацию аккаунта удалятором и ручкой commit восстановления
    ACCOUNT_DELETION_RESTORE_POSSIBLE_PERIOD = ACCOUNT_DELETION_QUARANTINE_PERIOD - timedelta(hours=1)
else:
    ACCOUNT_DELETION_RESTORE_POSSIBLE_PERIOD = ACCOUNT_DELETION_QUARANTINE_PERIOD - timedelta(minutes=1)

if yenv.type not in {'development', 'testing'}:     # pragma: no cover
    ACCOUNT_FRESH_PERIOD = timedelta(days=7)
else:
    ACCOUNT_FRESH_PERIOD = timedelta(minutes=10)
