# -*- coding: utf-8 -*-
import yenv


_AFISHA_API_URLS = {
    'testing': 'https://api.afisha.tst.yandex.net',
    'production': 'https://api.afisha.yandex.net',
}

_AFISHA_API_URLS['development'] = _AFISHA_API_URLS['testing']
_AFISHA_API_URLS['rc'] = _AFISHA_API_URLS['production']

_AFISHA_FRONT_URLS = {
    'testing': 'https://afisha.tst.yandex.ru',
    'production': 'https://afisha.yandex.ru',
}

_AFISHA_FRONT_URLS['development'] = _AFISHA_FRONT_URLS['testing']
_AFISHA_FRONT_URLS['rc'] = _AFISHA_FRONT_URLS['production']

if yenv.name == 'localhost':
    AFISHA_API_URL = _AFISHA_API_URLS[yenv.type]
    AFISHA_FRONT_URL = _AFISHA_FRONT_URLS[yenv.type]
else:
    AFISHA_API_URL = ''
    AFISHA_FRONT_URL = ''

AFISHA_API_TIMEOUT = 1

AFISHA_API_RETRIES = 2
