# -*- coding: utf-8 -*-

from .tlds import (
    PASSPORT_TLDS,
    PORTAL_EXTRA_TLDS,
)


ADDITIONAL_ALLOWED_RETPATH_SCHEMES = frozenset([
    'browser',
    'morda',
    'viewport',
    'yamarket',
    # https://st.yandex-team.ru/PASSP-30203
    'yandexmusic',
    'ya-search-app-open',
    'yamb',
])

ALLOWED_RETPATH_SCHEME_PREFIXES = frozenset([
    'yandex',
    'ru.yandex.',
    'com.yandex.',
])

ALLOWED_HOSTS = frozenset(
    ['yandex.%s' % tld for tld in PASSPORT_TLDS] +
    # Дополнительные tld, кроме yandex.net, который целиком заблокирован
    ['yandex.%s' % tld for tld in PORTAL_EXTRA_TLDS if tld != 'net'] +
    [
        'yadi.sk',
        'fotka.ru',
        'fotki.ru',
        'galatasaray.net',
        'kinopoisk.ru',
        'ndex.ru',
        'ruscorpora.ru',
        'sunduk.ru',
        'tut.by',
        'ya.ru',
        'yandes.ru',
        'yandex-team.ru',
        'bringly.ru',
        'edadeal.ru',
        'edastage.ru',  # тестинг Едадила
        'yandexsport.ru',
        'k50.ru',
        'k50dev.ru',  # тестинг k50
        'k50wldev.ru',  # тестинг k50
        'toloka.ai',
        'toloka-test.ai',
        'yandex.delivery',
        'yango.delivery',
        'yango.com',
        'auto.ru',
        'avto.ru',
        'practicum.com',
        'dzen.ru',
    ],
)


# TODO: кажется, можно удалять настройку
ALLOWED_PDD_HOSTS = frozenset(
    ['passport.yandex.%s' % tld for tld in PASSPORT_TLDS] +
    ['mail.yandex.%s' % tld for tld in PASSPORT_TLDS] +
    [
        'calendar.yandex.ru',
        'passport-test.yandex.ru',
        'passport-rc.yandex.ru',
        'passportdev.yandex.ru',
    ],
)


PDD_DOMAIN_RETPATH_WRAPPER_MAP = {
    'tut.by': 'https://profile.tut.by/logout/?retpath=%s',
}


_TLD_REGEXP = '(?:%s)' % '|'.join(PASSPORT_TLDS + PORTAL_EXTRA_TLDS).replace('.', '\.')

HOSTS_BLACKLIST = frozenset([
    '^an\.yandex\.%s$' % _TLD_REGEXP,  # PASSP-13826 СИБ попросила закрыть
    '^yabs\.yandex\.%s$' % _TLD_REGEXP,  # PASSP-10618 Допускает open redirect
    '^(?:\S+\.)?yandex\.net$',  # PASSP-11976 Закрываем весь yandex.net (покрывает и PASSP-11209)
    '^clck\.yandex\.%s$' % _TLD_REGEXP,  # PASSP-15048 Запретить в ретпасе урлы clck
    '^news-clck\.yandex\.%s$' % _TLD_REGEXP,  # PASSP-16384 Запретить в ретпасе урлы news-clck

    # PASSP-14596 Не допускаем "%" в имени хоста, т.к. одни браузеры декодируют
    # его (ie11), а другие нет (firefox38.8).
    '^.*%.*$',
])

# Список запрещенных путей на заданных хостах
HOSTS_WITH_PATHS_BLACKLIST = frozenset([
    ('^yandex\.%s$' % _TLD_REGEXP, '^/clck/.*$'),  # PASSP-15048 Запретить в ретпасе урлы clck
    ('^yandex\.%s$' % _TLD_REGEXP, '^/count/.*$'),  # PASSP-25851 Запретить в ретпасе счётчики
])


ALLOWED_PDD_TLDS = PASSPORT_TLDS
DEFAULT_PDD_RETPATH_WITHOUT_TLD = 'https://mail.yandex.%s/'
