# -*- coding: utf-8 -*-
from frozendict import frozendict
import yenv


# Альтернативные домены и соответствующие идентификаторы
# https://a.yandex-team.ru/arc/trunk/arcadia/passport/infra/daemons/blackbox/config/configs/yateam-blackbox-include.xml
if yenv.name == 'intranet':
    ALT_DOMAINS = frozendict({
        'auto.ru': 1120001,
        'metabar.ru': 1120002,
        'yaprobki.ru': 1120003,
        'sintegro.com': 1120004,
        'ext.yandex.ru': 1120005,
        'k50.ru': 1120006,
        'openyard.ru': 1120007,
        'meteum.ai': 1120008,
        'yango.com': 1120009,
        'cloudil.co.il': 1120010,
        'srb.tech': 1120011,
        'userver.tech': 1120012,
        'legal.direct': 1120013,
    })
    ALT_DOMAINS_AVAILABLE_AT_REGISTRATION = ALT_DOMAINS
else:
    ALT_DOMAINS = frozendict({
        'galatasaray.net': 1,
        'kinopoisk.ru': 2,
    })
    ALT_DOMAINS_AVAILABLE_AT_REGISTRATION = ()
