# -*- coding: utf-8 -*-
"""
Правила выбора подписок для отправки пушей в АМ.
Алгоритм выбора - first match, то есть, разрешить ru.yandex.mobile в iOS
только версий с 6.5.4 до 7.0.1 можно так:

AppRule(
    platform="ios", app_id="ru.yandex.mobile", min_version="6.5.4",
    max_version="7.0.1", allow=True,
),
AppRule(platform="ios", app_id="ru.yandex.mobile", allow=False)

Платформа указывается как "android", "ios"
Если есть препроцессинг app id (например, постфикс .passport для android),
то указывать итоговое значение

ForbidRule - это шортхэнд для AppRule(allow=False)
min и max_version можно оверрайдить.
"""
from passport.backend.api.settings.am_pushes.classes import (
    AllowRule,
    ForbidRule,
    PLATFORM_ANDROID,
    PLATFORM_IOS,
)


AM_SUBSCRIPTION_APP_RULES = [
    # PASSP-35076
    # ПП
    ForbidRule(platform=PLATFORM_IOS, app='ru.yandex.mobile.search', version_to='6.5.4'),
    # Почта
    ForbidRule(platform=PLATFORM_IOS, app='ru.yandex.mail', version_to='6.5.4'),
    # Браузер
    ForbidRule(platform=PLATFORM_IOS, app='ru.yandex.mobile', version_to='6.5.4'),
    ForbidRule(platform=PLATFORM_ANDROID, push_service='family_pay', version_to='7.23.15'),

    # Для интеграционных тестов
    ForbidRule(platform=PLATFORM_ANDROID, app='ru.yandex.autotests.blk.pushes.android.passport'),
    ForbidRule(platform=PLATFORM_IOS, app='ru.yandex.autotests.blk.am.pushes.ios'),

    # Янго, убер, дели
    ForbidRule(platform=PLATFORM_IOS, app='ru.yandex.yango'),
    ForbidRule(platform=PLATFORM_IOS, app='ru.yandex.yango.inhouse'),
    ForbidRule(platform=PLATFORM_IOS, app='ru.yandex.yango.develop'),
    ForbidRule(platform=PLATFORM_IOS, app='ru.yandex.yangodeli'),
    ForbidRule(platform=PLATFORM_IOS, app='ru.yandex.yangodeli.develop'),
    ForbidRule(platform=PLATFORM_IOS, app='ru.yandex.yangodeli.inhouse'),
    ForbidRule(platform=PLATFORM_IOS, app='ru.yandex.uber'),
    ForbidRule(platform=PLATFORM_ANDROID, app='com.yandex.yango.passport'),
    ForbidRule(platform=PLATFORM_ANDROID, app='com.yandex.yango.debug.passport'),
    ForbidRule(platform=PLATFORM_ANDROID, app='com.yandex.yango.beta.passport'),
    ForbidRule(platform=PLATFORM_ANDROID, app='com.yandex.yango.develop.passport'),
    ForbidRule(platform=PLATFORM_ANDROID, app='com.yandex.yangodeli.passport'),
    ForbidRule(platform=PLATFORM_ANDROID, app='com.yandex.yangodeli.debug.passport'),
    ForbidRule(platform=PLATFORM_ANDROID, app='com.yandex.yangodeli.beta.passport'),
    ForbidRule(platform=PLATFORM_ANDROID, app='com.yandex.yangodeli.develop.passport'),
    ForbidRule(platform=PLATFORM_ANDROID, app='ru.yandex.uber.passport'),
]


YAKEY_SUBSCRIPTION_APP_RULES = [
    # Существующее приложение Ключа
    AllowRule(platform=PLATFORM_ANDROID, app='ru.yandex.key'),
    AllowRule(platform=PLATFORM_IOS, app='ru.yandex.mobile.kluch'),
    AllowRule(platform=PLATFORM_IOS, app='ru.yandex.mobile.kluch.adhoc'),
    AllowRule(platform=PLATFORM_IOS, app='ru.yandex.mobile.kluch.dev'),
    # Разрабатываемое приложение Ключа
    AllowRule(platform=PLATFORM_ANDROID, app='com.yandex.auth.authenticator.android'),
    # Всё, что не разрешено - запрещено
    ForbidRule(),
]
