# -*- coding: utf-8 -*-

PLATFORM_ANDROID = 'android'
PLATFORM_IOS = 'ios'


class AmAppRule(object):
    def __init__(
        self,
        platform=None,
        app=None,
        push_service=None,
        event=None,
        version_from=None,
        version_to=None,
        allow=True,
    ):
        """
        Правило фильтрации подписок

        :param platform: платформа, "android"/"ios", опционально
        :param app: app id, опционально
        :param push_service: значение push_service, опционально
        :param event: значение event, опционально
        :param version_from: минимальная версия, "1.0.0", опционально
        :param version_to: максимальная версия, "1.0.0", опционально
        :param allow: разрешающее правило, bool, def=True
        """
        self.platform = platform
        self.app = app
        self.push_service = push_service
        self.event = event
        self.version_from = version_from
        self.version_to = version_to
        self.allow = allow

    def __str__(self):
        attrs = ('platform', 'app', 'push_service', 'event', 'version_from', 'version_to')
        return '{} {}'.format(
            'ALLOW' if self.allow else 'DENY',
            ' '.join(
                '{}={}'.format(attr, getattr(self, attr))
                for attr in attrs if attr is not None
            ),
        )

    def __repr__(self):
        return '{}({})'.format(self.__class__.__name__, self)


AllowRule = AmAppRule


class ForbidRule(AmAppRule):
    """ Шортхэнд для allow=False """
    def __init__(
        self,
        platform=None,
        app=None,
        push_service=None,
        event=None,
        version_from=None,
        version_to=None,
    ):
        super(ForbidRule, self).__init__(
            platform=platform,
            app=app,
            push_service=push_service,
            event=event,
            version_from=version_from,
            version_to=version_to,
            allow=False,
        )
