# -*- coding: utf-8 -*-
import yenv


_ANTIFRAUD_API_URL = {
    'localhost': {
        'production': 'https://so-fraud.pers.yandex.net',  # SPI-26804
        'rc': 'https://so-fraud.pers.yandex.net',
        'testing': 'https://fraud-test.so.yandex-team.ru',
        'development': 'https://fraud-test.so.yandex-team.ru',
    },
}

ANTIFRAUD_API_URL = _ANTIFRAUD_API_URL.get(yenv.name, {}).get(yenv.type)

_ANTIFRAUD_AUTH_SUB_CHANNEL = {
    'production': 'login',
    'rc': 'login',
    'testing': 'test-login',
    'development': 'login',  # только для тестов
}

ANTIFRAUD_AUTH_SUB_CHANNEL = _ANTIFRAUD_AUTH_SUB_CHANNEL.get(yenv.type, '')

ANTIFRAUD_ON_CHALLENGE_ENABLED = yenv.name == 'localhost' and yenv.type in ['testing', 'rc', 'production']
ALLOW_ANTIFRAUD_ON_CHALLENGE_ON_TEST_YANDEX_LOGIN = yenv.name == 'localhost' and yenv.type == 'testing'
ANTIFRAUD_API_TIMEOUT = 0.5
ANTIFRAUD_API_RETRIES = 1

PHONE_CONFIRM_CHECK_IP_BLACKLIST = True
PHONE_CONFIRM_CHECK_ANTIFRAUD_SCORE = yenv.name == 'localhost' and yenv.type in ['rc', 'production']
if yenv.type == 'rc':
    PHONE_CONFIRM_SHOW_ANTIFRAUD_CAPTCHA_FOR_CONSUMERS = (
        'passport',
    )
else:
    PHONE_CONFIRM_SHOW_ANTIFRAUD_CAPTCHA_FOR_CONSUMERS = ()

PHONE_CONFIRM_MASK_ANTIFRAUD_DENIAL = yenv.type in ['rc', 'production']

ANTIFRAUD_SHOW_CHALLENGE_ON_FAIL = yenv.name == 'localhost' and yenv.type in ['rc', 'production']

# приоритет челленджей для антифродной тыквы
ANTIFRAUD_FALLBACK_CHALLENGES = ['phone_confirmation', 'question']
# Для phone_confirmation челленджа могут быть добавлены [flash_call, sms, call] тэги
ANTIFRAUD_FALLBACK_PHONE_CHALLENGES = ['sms']

FAMILY_INVITES_VIA_EMAIL_CHECK_ANTIFRAUD_SCORE = True
