# -*- coding: utf-8 -*-
from .social import AUTH_ALLOWED_PROVIDER_TO_ID


AUTH_METHOD_UNKNOWN = None
AUTH_METHOD_PASSWORD = 'password'
AUTH_METHOD_OTP = 'otp'
AUTH_METHOD_MAGIC = 'magic'
AUTH_METHOD_MAGIC_X_TOKEN = 'magic_x_token'
AUTH_METHOD_MAGIC_LINK = 'magic_link'
AUTH_METHOD_SMS_CODE = 'sms_code'
AUTH_METHOD_SAML_SSO = 'saml_sso'

AUTH_METHOD_SOCIAL_PREFIX = 'social_'
AUTH_METHOD_SOCIAL_TEMPLATE = AUTH_METHOD_SOCIAL_PREFIX + '%s'
_AUTH_METHOD_SOCIAL_OFFSET = 20


def _build_auth_method_mapping():
    mapping = {
        AUTH_METHOD_UNKNOWN: 0,  # тут должен быть именно ноль, код на это полагается
        AUTH_METHOD_PASSWORD: 1,
        AUTH_METHOD_OTP: 2,
        AUTH_METHOD_MAGIC: 3,
        AUTH_METHOD_MAGIC_LINK: 4,
        AUTH_METHOD_MAGIC_X_TOKEN: 5,
        AUTH_METHOD_SMS_CODE: 6,
        AUTH_METHOD_SAML_SSO: 7,
    }
    for provider, id_ in AUTH_ALLOWED_PROVIDER_TO_ID.items():
        mapping[AUTH_METHOD_SOCIAL_TEMPLATE % provider] = _AUTH_METHOD_SOCIAL_OFFSET + id_
    return mapping


AUTH_METHOD_TO_ID = _build_auth_method_mapping()
AUTH_METHOD_FROM_ID = {
    method_id: method
    for method, method_id in AUTH_METHOD_TO_ID.items()
}
