# -*- coding: utf-8 -*-
from six.moves.urllib.parse import urlparse
import yenv


_AVATARS_URLS = {
    'testing': {
        'read': 'https://avatars.mdst.yandex.net',
        'write': 'http://avatars-int.mdst.yandex.net:13000',
    },
    'production': {
        'read': 'https://avatars.mds.yandex.net',
        'write': 'http://avatars-int.mds.yandex.net:13000',
    },
}
_AVATARS_URLS['stress'] = _AVATARS_URLS['development'] = _AVATARS_URLS['testing']
_AVATARS_URLS['rc'] = _AVATARS_URLS['production']

AVATARS_READ_URL = _AVATARS_URLS[yenv.type]['read']
AVATARS_WRITE_URL = _AVATARS_URLS[yenv.type]['write']

AVATARS_YAPIC_NAMESPACE = 'yapic'

AVATARS_RETRIES = 1
AVATARS_TIMEOUT = 5

AVATAR_DEFAULT_SIZE = 'normal'

DEFAULT_AVATAR_KEY = '0/0-0'
GET_AVATAR_URL = AVATARS_READ_URL + '/get-yapic/%s/%s'
GET_AVATAR_URL_SCHEMALESS = urlparse(AVATARS_READ_URL).netloc + '/get-yapic/%s/'


# параметры для секрета в урле аватарки
_AVATAR_WITH_SECRET_URLS = {
    'localhost': {
        'testing': 'https://api.passport-test.yandex.ru/',
        'rc': 'https://api.passport-rc.yandex.ru/',
        'production': 'https://api.passport.yandex.ru/',
    },
    'stress': {
        'stress': '',
    },
    'intranet': {},
}

_AVATAR_WITH_SECRET_URLS['intranet']['production'] = _AVATAR_WITH_SECRET_URLS['localhost']['production']
_AVATAR_WITH_SECRET_URLS['intranet']['rc'] = _AVATAR_WITH_SECRET_URLS['localhost']['rc']
_AVATAR_WITH_SECRET_URLS['intranet']['testing'] = _AVATAR_WITH_SECRET_URLS['intranet']['development'] = _AVATAR_WITH_SECRET_URLS['localhost']['testing']
_AVATAR_WITH_SECRET_URLS['localhost']['development'] = _AVATAR_WITH_SECRET_URLS['localhost']['testing']

_AVATAR_WITH_SECRET_URL = _AVATAR_WITH_SECRET_URLS[yenv.name][yenv.type]

GET_AVATAR_WITH_SECRET_URL = _AVATAR_WITH_SECRET_URL + 'avatar?key=%s&secret=%s'

# Параметры подписи секрета в ЧЯ
AVATAR_SECRET_TTL = 365 * 24 * 60 * 60  # В секундах
AVATAR_SECRET_SIGN_SPACE = 'avatar_secret'

if yenv.name == 'intranet':  # выключен в ya-team
    CHECK_AVATARS_SECRETS_DENOMINATOR = 0  # 0 %
    ISSUE_AVATARS_SECRETS = False
elif yenv.type in ('development', 'testing'):  # для удобства тестирования
    CHECK_AVATARS_SECRETS_DENOMINATOR = 1  # 100%
    ISSUE_AVATARS_SECRETS = True
else:  # production
    CHECK_AVATARS_SECRETS_DENOMINATOR = 0  # 0 %
    ISSUE_AVATARS_SECRETS = True
