# -*- coding: utf-8 -*-
import yenv

from .secrets import (
    BILET_API_CLIENT_KEY,
    BILET_API_KEY,
)


_BILET_API_URLS = {
    'localhost': {
        'development': 'https://api.tickets.afisha.tst.yandex.net/',
        'testing': 'https://api.tickets.afisha.tst.yandex.net/',
        'rc': 'https://api.tickets.afisha.yandex.net/',
        'production': 'https://api.tickets.afisha.yandex.net/',
    },
}

if yenv.name == 'localhost':
    BILET_API_URL = _BILET_API_URLS[yenv.name][yenv.type]
else:
    BILET_API_URL = ''

# Максимальное время ожидания ответа
BILET_API_TIMEOUT = 0.4

# Число попыток получить ответ
BILET_API_RETRIES = 2
