# -*- coding: utf-8 -*-

import yenv

from .secrets import BILLING_TOKEN


BILLING_XMLRPC_TIMEOUT = 2
BILLING_XMLRPC_RETRIES = 2

TRUST_PAYMENTS_TIMEOUT = 2
TRUST_PAYMENTS_RETRIES = 2

TRUST_BINDINGS_TIMEOUT = 2
TRUST_BINDINGS_RETRIES = 2


if yenv.type in {'development', 'testing'}:
    BILLING_XMLRPC_URL = 'https://trust-payments-test.paysys.yandex.net:8028/simple/xmlrpc'
    TRUST_PAYMENTS_URL = 'https://trust-payments-test.paysys.yandex.net:8028/trust-payments/v2/'
    TRUST_BINDINGS_URL = 'https://pci-tf.fin.yandex.net:443/api/'
    TRUST_BINDINGS_PUBLIC_KEY = """
-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA5i+9gXgNJbAKus8ltkwf
Bi33a/KwVvxsiILsrtoY/OQo2MJqBJZs0zJABGGGfEnQ3W1BP16nFeRwnTLBOOH8
D6fGHqjSFkwI9b95YsbjPe58UcAUkhKj5j3+gVywTzKkvDtURrFIrF7FjQY8ucfH
gA49N1Dac/5r436dmDrnbUGNtxkCWW9mlvnbaWfN9kMf/xK7JzAzDbJz9myZNTAi
r+y97vVxrXFPbyo5EKbWrtXYMwYsu0yjJckeYcG4SkGD3xvjgJs16mbq6KJM5HMo
KRuBWVoJ61+RLHJJ5DhqiPKvMa7s+7i17kyrJu91ZfOWZ0WRFHJOAx3PfK/TgVbA
8wIDAQAB
-----END PUBLIC KEY-----
"""
elif yenv.type in {'rc', 'production'}:
    BILLING_XMLRPC_URL = 'https://trust-payments.paysys.yandex.net:8028/simple/xmlrpc'
    TRUST_PAYMENTS_URL = 'https://trust-payments.paysys.yandex.net:8028/trust-payments/v2/'
    TRUST_BINDINGS_URL = 'https://diehard.yandex.net:443/api/'
    TRUST_BINDINGS_PUBLIC_KEY = """
-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAzUcBBR9XIdZc36O52t+X
0lhKsVbKJXYWUEvVjxYi50WND8QjNmBmC1mOGqumO09Uyn320ikDg3BaJJHtNK+Q
a8hE72E4m65nUL4fKVjTogHRh2q1Ne8kI2w6BifrYLQP3YjRRUmdEjLOS1LaHih8
DrIpJYjHVHaoQmXqqXZwWXIVT4TvAkN33u+YClDwVLHH4TAZNbD9edPE5b3OaO9P
GbxQZNB9yYAJDmeT3k/RkaMTtxRIQMiZJieFNmXqxNQmOgWbcwd+FvbIKxlUZ65o
u8IuaJrBVZrIk8HWZaa48l80Hki34fMyWH/tie9A0IzkdQyhM7Nf6XwMQ9rEkjl7
owIDAQAB
-----END PUBLIC KEY-----
"""
else:
    BILLING_XMLRPC_URL = ''
    TRUST_PAYMENTS_URL = ''
    TRUST_BINDINGS_URL = ''
    TRUST_BINDINGS_PUBLIC_KEY = ''


TRUST_3DS_CHALLENGE_PRODUCT_ID = '3ds_challenge_payment'
TRUST_3DS_CHALLENGE_PRODUCT_PRICE = 11  # в рублях
VALIDATE_CARD_ID_BEFORE_CREATING_CHAAS_TRACK = True
