# -*- coding: utf-8 -*-
import yenv

from .blackbox_fields import (
    BLACKBOX_ATTRIBUTES,
    BLACKBOX_BASIC_ATTRIBUTES,
    BLACKBOX_BASIC_FIELDS,
    BLACKBOX_DANGEROUS_ATTRIBUTES,
    BLACKBOX_FIELDS,
    BLACKBOX_PHONE_EXTENDED_ATTRIBUTES,
)


_BLACKBOX_URLS = {
    'intranet': {
        'development': 'http://bbdev-1.yandex-team.ru/',
        'testing': 'https://blackbox-test.yandex-team.ru/',
        'production': 'https://blackbox.yandex-team.ru/',
    },
    'localhost': {
        'development': 'https://pass-test.yandex.ru/',
        'testing': 'https://pass-test.yandex.ru/',
        'rc': 'https://blackbox-rc.yandex.net/',
        'production': 'https://blackbox.yandex.net/',
    },
    'stress': {
        'stress': 'https://pass-load.sezam.yandex.net/',
    },
}

_BLACKBOX_URLS['intranet']['rc'] = _BLACKBOX_URLS['intranet']['production']

BLACKBOX_URL = _BLACKBOX_URLS[yenv.name][yenv.type]

# максимальное время ожидания ответа ЧЯ
BLACKBOX_TIMEOUT = 0.5

# число попыток получить ответ от ЧЯ
BLACKBOX_RETRIES = 2

# Версии куки в ЧЯ
BLACKBOX_SESSION_VERSION = 3

# Максимальное число uid'ов, о которых можно спросить в одном запросе к ЧЯ
BLACKBOX_MAX_UIDS_PER_REQUEST = 100


_BB_TEST_UIDS = {
    'localhost': {
        'testing': 3000153923,
        'production': 172997057,
    },
    'stress': {
        'stress': 1000000,
    },
    'intranet': {
        'testing': 1100000000000005,
        'production': 1120000000011117,
    },
}
for env_name in ('localhost', 'intranet'):
    _BB_TEST_UIDS[env_name]['development'] = _BB_TEST_UIDS[env_name]['testing']
    _BB_TEST_UIDS[env_name]['rc'] = _BB_TEST_UIDS[env_name]['production']

# uid, который используется в ручке /ping,
# чтобы проверить работоспособность blackbox
# login: blackbox-availability-test
# pwd: oud5lol3ce
# секретный вопрос: 1+1=?
# ответ: 2
# NOTE: в intranet testing логин и пароль другие (bb-availability-test, ***) по техническим причинам
BLACKBOX_AVAILABILITY_TEST_UID = _BB_TEST_UIDS[yenv.name][yenv.type]

# Количество попыток хождения в ЧЯ в ручке /ping
BLACKBOX_AVAILABILITY_TEST_RETRIES = 2


TICKET_PARSER2_BLACKBOX_ENV = {
    'localhost': {
        'development': 'testing',
        'testing': 'testing',
        'rc': 'production',
        'production': 'production',
    },
    'intranet': {
        'development': 'intranet_testing',
        'testing': 'intranet_testing',
        'rc': 'intranet_production',
        'production': 'intranet_production',
    },
    'stress': {'stress': 'stress'},
}
TICKET_PARSER2_BLACKBOX_ENV = TICKET_PARSER2_BLACKBOX_ENV[yenv.name][yenv.type]
