# -*- coding: utf-8 -*-
import yenv

from . import secrets


_BOT_API_URLS = {
    'development': 'https://test.bp.mssngr.yandex.net',
    'testing': 'https://test.bp.mssngr.yandex.net',
    'rc': 'https://bp.mssngr.yandex.net',
    'production': 'https://bp.mssngr.yandex.net',
}

if yenv.name == 'localhost':
    BOT_API_URL = _BOT_API_URLS[yenv.type]
else:   # pragma: no cover
    BOT_API_URL = ''

BOT_API_TIMEOUT = 1

BOT_API_RETRIES = 2

BOT_API_TOKEN = secrets.BOT_API_TOKEN
