# -*- coding: utf-8 -*-
from frozendict import frozendict
import yenv


# адрес сервера капчи
CAPTCHA_URL = 'http://new.captcha.yandex.net/'
if yenv.name == 'stress':
    CAPTCHA_URL = 'http://passport-fake-services.passport-load.passport.yandex.net/captcha/'

# таймаут запроса к серверу капчи
CAPTCHA_TIMEOUT = 0.6
# количество попыток запроса к серверу капчи
CAPTCHA_RETRIES = 2
# количество разрешенных проверок одной и той же капчи
CAPTCHA_CHECKS = 1


def build_environments_with_same_captcha(captcha_name):
    return frozendict(
        dict.fromkeys(
            ['development', 'testing', 'stress', 'rc', 'production'],
            captcha_name,
        ),
    )

_LANGUAGES_WITH_RUS_CAPTCHA = [
    'be',  # Белорусский
    'hy',  # Армянский
    'kk',  # Казахский
    'ky',  # Киргизский
    'mo',  # Молдавский
    'ru',  # Русский
    'tg',  # Таджикский
    'tk',  # Туркменский
    'uk',  # Украинский
    'uz',  # Узбекский
]

_COUNTRIES_WITH_RUS_CAPTCHA = [
    'am',  # Армения
    'by',  # Беларусь
    'kg',  # Киргизия
    'kz',  # Казахстан
    'md',  # Молдова
    'ru',  # Россия
    'tj',  # Таджикистан
    'tm',  # Туркменистан
    'ua',  # Украина
    'uz',  # Узбекистан
]

_LANGUAGE = {
    lang: build_environments_with_same_captcha('rus2')
    for lang in _LANGUAGES_WITH_RUS_CAPTCHA
}
_LANGUAGE.update({
    'en': build_environments_with_same_captcha('nmixm'),
    'tr': build_environments_with_same_captcha('tr'),
    '': build_environments_with_same_captcha('nmixm'),
})

_COUNTRY = {
    country: build_environments_with_same_captcha('rus2')
    for country in _COUNTRIES_WITH_RUS_CAPTCHA
}
_COUNTRY.update({
    'tr': build_environments_with_same_captcha('tr'),
    '': build_environments_with_same_captcha('nmixm'),
})

_WAVE_BY_LANGUAGE = {
    lang: build_environments_with_same_captcha('txt_v1')
    for lang in _LANGUAGES_WITH_RUS_CAPTCHA
}
_WAVE_BY_LANGUAGE.update({
    '': build_environments_with_same_captcha('txt_v1_en'),
})

_WAVE_BY_COUNTRY = {
    country: build_environments_with_same_captcha('txt_v1')
    for country in _COUNTRIES_WITH_RUS_CAPTCHA
}
_WAVE_BY_COUNTRY.update({
    '': build_environments_with_same_captcha('txt_v1_en'),
})

# Тип очереди капчи не зависит от переменной yenv.name
CAPTCHA_LANGUAGE_MATCHING = {x: y[yenv.type] for x, y in _LANGUAGE.items()}
CAPTCHA_COUNTRY_MATCHING = {x: y[yenv.type] for x, y in _COUNTRY.items()}
WAVE_CAPTCHA_LANGUAGE_MATCHING = {x: y[yenv.type] for x, y in _WAVE_BY_LANGUAGE.items()}
WAVE_CAPTCHA_COUNTRY_MATCHING = {x: y[yenv.type] for x, y in _WAVE_BY_COUNTRY.items()}

_VOICE_LANGUAGES = {
    'ru': {'development': 'ru', 'testing': 'ru', 'rc': 'ru', 'production': 'ru', 'stress': 'ru'},
    'tr': {'development': 'tr', 'testing': 'tr', 'rc': 'tr', 'production': 'tr', 'stress': 'tr'},
    '': {'development': 'ru', 'testing': 'ru', 'rc': 'ru', 'production': 'ru', 'stress': 'ru'},
}

_VOICE_COUNTRIES = {
    'ru': {'development': 'ru', 'testing': 'ru', 'rc': 'ru', 'production': 'ru', 'stress': 'ru'},
    'ua': {'development': 'ru', 'testing': 'ru', 'rc': 'ru', 'production': 'ru', 'stress': 'ru'},
    'by': {'development': 'ru', 'testing': 'ru', 'rc': 'ru', 'production': 'ru', 'stress': 'ru'},
    'kz': {'development': 'ru', 'testing': 'ru', 'rc': 'ru', 'production': 'ru', 'stress': 'ru'},
    'tr': {'development': 'tr', 'testing': 'tr', 'rc': 'tr', 'production': 'tr', 'stress': 'tr'},
    # fallback - MUST be present
    '': {'development': 'ru', 'testing': 'ru', 'rc': 'ru', 'production': 'ru', 'stress': 'ru'},
}

# Тип очереди для голосовой капчи
CAPTCHA_VOICE_LANGUAGE_MATCHING = {x: y[yenv.type] for x, y in _VOICE_LANGUAGES.items()}
CAPTCHA_VOICE_COUNTRY_MATCHING = {x: y[yenv.type] for x, y in _VOICE_COUNTRIES.items()}

_RUS2_SCALED = {
    2: 'rus2_s2',
    3: 'rus2_s3',
}
_SCALES = {
    'rus2': {
        'development': _RUS2_SCALED.copy(),
        'testing': _RUS2_SCALED.copy(),
        'rc': _RUS2_SCALED.copy(),
        'production': _RUS2_SCALED.copy(),
        'stress': _RUS2_SCALED.copy(),
    },
}

CAPTCHA_SCALE_MATCHING = {k: v[yenv.type] for k, v in _SCALES.items()}

# Типы треков, для которых мы врубаем нерешаемую капчу при условии плохой ASки
DISABLED_FOR_BLACK_AS_CAPTCHA_TRACK_TYPES = ['register']
