# -*- coding: utf-8 -*-
import yenv


_CLEAN_WEB_API_URLS = {
    'development': 'https://cw-router-dev.common.yandex.net',
    'testing': 'https://cw-router-prod.common.yandex.net',
    'rc': 'https://cw-router-prod.common.yandex.net',
    'production': 'https://cw-router-prod.common.yandex.net',
}

if yenv.name == 'localhost':
    CLEAN_WEB_API_URL = _CLEAN_WEB_API_URLS[yenv.type]
else:   # pragma: no cover
    CLEAN_WEB_API_URL = ''

CLEAN_WEB_API_TIMEOUT = 0.2

CLEAN_WEB_API_RETRIES = 1

# можно выключить хождение в clean web api
CLEAN_WEB_API_ENABLED = yenv.name == 'localhost'
