# -*- coding: utf-8 -*-

from datetime import timedelta

import yenv


# 24 часа в секундах - для определения интервалов времени (два дня, неделя)
TIMESTAMP_DELTA_ONE_DAY = 24 * 60 * 60

SESSIONAL_COOKIE_TTL = 0
SHORT_COOKIE_TTL = 4
PERMANENT_COOKIE_TTL = 5

KIDDISH_LOGIN_GENERATION_RETRIES = 5
KOLONKISH_LOGIN_GENERATION_RETRIES = 5
PHONISH_LOGIN_GENERATION_RETRIES = 5
YAMBOT_LOGIN_GENERATION_RETRIES = 5

OTP_SECRET_GENERATION_RETRIES = 5

# Символы, запрещенные к появлению в строчке с хостом/логином/паролем в URL
# пути редиректа.
RETPATH_BAD_SYMBOLS = set('\t\r\n\0')

# Страна по умолчанию
DEFAULT_COUNTRY = 'ru'

# Язык по умолчанию
DEFAULT_LANGUAGE = 'ru'

# Удаленные типы треков. которые эмулируются в API
DELETED_TRACK_TYPES = ('account', 'social')

if yenv.type in {'development', 'testing', 'rc'}:
    RECENT_ACCOUNT_USAGE_PERIOD = timedelta(minutes=5)
else:
    RECENT_ACCOUNT_USAGE_PERIOD = timedelta(days=60)


DATA_TYPE_NAME = 'name'
DATA_TYPE_PASSWORD = 'password'
DATA_TYPE_PHONE_NUMBER = 'phone_number'

DATA_STATUS_NOT_USED = 'not_used'
DATA_STATUS_OPTIONAL = 'optional'
DATA_STATUS_REQUIRED = 'required'
