# -*- coding: utf-8 -*-

from collections import defaultdict

import yenv

from .account_modification import ACCOUNT_MODIFICATION_PER_UID_COUNTER_TEMPLATE
from .antifraud import (
    KOLMOGOR_ANTIFRAUD_CALL_FAIL_COUNTERS_1H,
    KOLMOGOR_ANTIFRAUD_CALL_FAIL_COUNTERS_10MIN,
    KOLMOGOR_ANTIFRAUD_CALL_FAIL_COUNTERS_24H,
    KOLMOGOR_KEYSPACE_ANTIFRAUD_FAIL_CALLS_COUNTER_1H,
    KOLMOGOR_KEYSPACE_ANTIFRAUD_FAIL_CALLS_COUNTER_10MIN,
    KOLMOGOR_KEYSPACE_ANTIFRAUD_FAIL_CALLS_COUNTER_24H,
)
from .auth_challenge_per_ip import AUTH_CHALLENGE_PER_IP_LIMIT_COUNTER
from .auth_email import (
    AUTH_EMAIL_RECENTLY_SENT_COUNTER,
    EMAIL_CHECK_OWNERSHIP_SENT_COUNTER_1H,
    EMAIL_CHECK_OWNERSHIP_SENT_COUNTER_24H,
    KOLMOGOR_KEY_SPACE_EMAIL_CHECK_OWNERSHIP_SENT_COUNTER_1H,
    KOLMOGOR_KEY_SPACE_EMAIL_CHECK_OWNERSHIP_SENT_COUNTER_24H,
)
from .auth_magic_link import (
    AUTH_MAGIC_LINK_EMAIL_SENT_PER_IP_COUNTER,
    AUTH_MAGIC_LINK_EMAIL_SENT_PER_UID_COUNTER,
    AUTH_MAGIC_LINK_EMAIL_SENT_PER_UNTRUSTED_IP_COUNTER,
)
from .auth_push import (
    AUTH_PUSH_COUNTER,
    AUTH_PUSH_KOLMOGOR_KEY_SPACE,
    PUSH_2FA_COUNTER,
    PUSH_2FA_KOLMOGOR_KEY_SPACE,
)
from .bad_rfc_otp import BAD_RFC_OTP_COUNTER
from .calls_per_ip import (
    PHONE_CONFIRMATION_CALLS_PER_IP_LIMIT_COUNTER,
    UNTRUSTED_PHONE_CONFIRMATION_CALLS_PER_IP_LIMIT_COUNTER,
)
from .calls_per_phone import CALLS_PER_PHONE_LIMIT_COUNTER
from .change_password import (
    CHANGE_PASSWORD_PER_PHONE_NUMBER_LIMIT_COUNTER,
    CHANGE_PASSWORD_PER_USER_IP_LIMIT_COUNTER,
)
from .check_answer import (
    CHECK_ANSWER_PER_IP_AND_UID_LIMIT_COUNTER,
    CHECK_ANSWER_PER_IP_LIMIT_COUNTER,
    CHECK_ANSWER_PER_UID_LIMIT_COUNTER,
)
from .drive import (
    DRIVE_CREATE_DEVICE_PUBLIC_KEY_RPD_COUNTER,
    DRIVE_CREATE_DEVICE_PUBLIC_KEY_RPS_COUNTER,
)
from .email_validator import (
    VALIDATOR_EMAIL_SENT_PER_UID_AND_ADDRESS_COUNTER,
    VALIDATOR_EMAIL_SENT_PER_UID_COUNTER,
)
from .family import (
    FAMILY_INVITE_ISSUE_PER_FAMILY_COUNTER,
    FAMILY_INVITE_ISSUE_PER_UID_COUNTER,
    FAMILY_INVITE_KOLMOGOR_KEY_SPACE,
)
from .migrate_mailish import MIGRATE_MAILISH_PER_CONSUMER_COUNTER
from .passman_recovery_key import PASSMAN_RECOVERY_KEY_ADD_COUNTER
from .profile_fails import PROFILE_FAILS_COUNTER
from .question_change_email_notification import QUESTION_CHANGE_EMAIL_NOTIFICATION_COUNTER
from .register_mailish import REGISTER_MAILISH_PER_CONSUMER_COUNTER
from .register_phonish_by_phone import REGISTER_PHONISH_BY_PHONE_PER_CONSUMER_COUNTER
from .registration_email import (
    REGISTRATION_EMAIL_PER_EMAIL_LIMIT_COUNTER,
    REGISTRATION_EMAIL_PER_IP_LIMIT_COUNTER,
    REGISTRATION_EMAIL_PER_UNTRUSTED_IP_LIMIT_COUNTER,
)
from .registration_karma import (
    REGKARMA_BAD_COUNTER,
    REGKARMA_GOOD_COUNTER,
)
from .registration_kolonkish import (
    REGISTRATION_KOLONKISH_PER_CREATOR_UID_LONG_TERM,
    REGISTRATION_KOLONKISH_PER_CREATOR_UID_SHORT_TERM,
)
from .registration_social import (
    SOCIALREG_PER_IP_CAPTCHA_LIMIT_COUNTER,
    SOCIALREG_PER_PROVIDER_CAPTCHA_LIMIT_COUNTER,
)
from .registration_uncompleted import (
    UNCOMPLETEDREG_CALLS_CAPTCHA_LIMIT_COUNTER,
    UNCOMPLETEDREG_PER_IP_CAPTCHA_LIMIT_COUNTER,
)
from .restore import (
    LOGIN_RESTORE_PER_IP_LIMIT_COUNTER,
    LOGIN_RESTORE_PER_PHONE_LIMIT_COUNTER,
    RESTORE_PER_IP_LIMIT_COUNTER,
    RESTORE_SEMI_AUTO_COMPARE_PER_IP_LIMIT_COUNTER,
    RESTORE_SEMI_AUTO_COMPARE_PER_UID_LIMIT_COUNTER,
)
from .sms_per_ip import (
    AUTH_FORWARDING_SMS_PER_IP_LIMIT_COUNTER,
    PHONE_CONFIRMATION_SMS_PER_IP_FOR_APP_COUNTER_FMT,
    PHONE_CONFIRMATION_SMS_PER_IP_FOR_CONSUMER_COUNTER_FMT,
    PHONE_CONFIRMATION_SMS_PER_IP_LIMIT_COUNTER,
    REGISTRATION_COMPLETED_WITH_SMS_PER_IP_LIMIT_COUNTER,
    REGISTRATION_SMS_SENT_PER_IP_LIMIT_COUNTER,
    UNTRUSTED_AUTH_FORWARDING_SMS_PER_IP_LIMIT_COUNTER,
    UNTRUSTED_PHONE_CONFIRMATION_SMS_PER_IP_LIMIT_COUNTER,
    UNTRUSTED_REGISTRATION_COMPLETED_WITH_SMS_PER_IP_LIMIT_COUNTER,
)
from .sms_per_phone import (
    SMS_PER_PHONE_LIMIT_COUNTER,
    SMS_PER_PHONE_ON_REGISTRATION_LIMIT_COUNTER,
    SMS_PER_PHONISH_ON_REGISTRATION_LIMIT_COUNTER,
)
from .userinfo import SHORT_USERINFO_COUNTER
from .yakey_2fa_pictures import YAKEY_2FA_PICTURES_SHOWN_COUNTER
from .yapic import (
    YAPIC_DELETE_PER_IP_LIMIT_COUNTER,
    YAPIC_DELETE_PER_UID_LIMIT_COUNTER,
    YAPIC_UPLOAD_PER_IP_LIMIT_COUNTER,
    YAPIC_UPLOAD_PER_UID_LIMIT_COUNTER,
)


_COUNTERS_REDIS_MANAGERS = {
    'other': {
        # Не важно где, хост мокается в 0x7F
        'development': defaultdict(lambda: 0x7F),  # passportdev-python.yandex.net
        'testing': {
            's1': 0x9,   # passport-test-s1.passport.yandex.net
            'v1': 0x8C,  # passport-test-v1.passport.yandex.net
        },
        'rc': {
            # Фейковые DC для машин из RC
            'v1rc': 0xE3,  # passport-rc-v1.passport.yandex.net
            's1rc': 0xE2,  # passport-rc-s1.passport.yandex.net
        },
        'production': {
            'v': 0x1,    # passport-v1.passport.yandex.net
            'i': 0x10,   # passport-i1.passport.yandex.net
            'm': 0x20,   # passport-m1.passport.yandex.net
            's': 0x4A,   # passport-s1.passport.yandex.net

            # Фейковые DC для машин из RC.
            'v1rc': 0xE3,  # passport-rc-v1.passport.yandex.net
            's1rc': 0xE2,  # passport-rc-s1.passport.yandex.net
        },
    },
    'stress': {
        'stress': defaultdict(lambda: 0x5F),
    },
    'intranet': {
        'development': dict(),
        'testing': {
            's1': 0x54,  # passport-yateam-test-s1.passport.yandex.net
            'v1': 0x55,  # passport-yateam-test-v1.passport.yandex.net
        },
        'rc': {
            # Фейковые DC для машин из RC
            'v1rc': 0x3D,  # passport-yateam-rc-v1.passport.yandex.net
            's1rc': 0x3C,  # passport-yateam-rc-s1.passport.yandex.net
        },
        'production': {
            'v': 0x38,  # passport-yateam-v1.passport.yandex.net
            'i': 0x39,  # passport-yateam-i1.passport.yandex.net
            'm': 0x4E,  # passport-yateam-m1.passport.yandex.net
            's': 0x88,  # passport-yateam-s1.passport.yandex.net
        },
    },
}

_COUNTERS_REDIS_MANAGERS['localhost'] = _COUNTERS_REDIS_MANAGERS['other']

COUNTERS_REDIS_MANAGERS = _COUNTERS_REDIS_MANAGERS[yenv.name][yenv.type]


# Общее описание счётчиков
#
# Записи имеют вид: "префикс: (ЧИСЛО, ДЛИНА, ЛИМИТ)".
# Это означает, что действие может быть выполнено не более чем ЛИМИТ раз за
# промежуток в (ЧИСЛО * ДЛИНА) секунд.

_DEFAULT_COUNTER_VALUES = {
    # Пользователь может отослать не более N писем в день на один адрес.
    VALIDATOR_EMAIL_SENT_PER_UID_AND_ADDRESS_COUNTER: (24, 3600, 10),
    # Пользователь может отослать не более N писем в день на любые адреса.
    VALIDATOR_EMAIL_SENT_PER_UID_COUNTER: (24, 3600, 3),

    # PASSP-3753
    # Пользователь с адресом А и с плохой кармой зарегистрирован C раз.
    REGKARMA_BAD_COUNTER: (6, 3600, 100),
    # Пользователь с адресом А и хорошей кармой зарегистрирован С раз.
    # Лимит Л, означает, что, если пользователь с хорошей кармой
    # зарегистрировался Л, Л + 1, Л + 2, .. раз, то не обращаем внимание на
    # пользователей с плохой кармой.
    REGKARMA_GOOD_COUNTER: (24, 3600, 1),

    # Пользователь социальной сети с адресом А зарегистрирован С раз.
    SOCIALREG_PER_IP_CAPTCHA_LIMIT_COUNTER: (6, 600, 200),
    # Пользователь из социальной сети ВК зарегистрирован С раз.
    SOCIALREG_PER_PROVIDER_CAPTCHA_LIMIT_COUNTER: (6, 600, 100000),

    # Ручка частичной регистрации пользователя вызвана C раз.
    UNCOMPLETEDREG_CALLS_CAPTCHA_LIMIT_COUNTER: (24, 3600, 1000),
    # Пользователь с адресом A вызвал ручку частичной регистрации C раз.
    UNCOMPLETEDREG_PER_IP_CAPTCHA_LIMIT_COUNTER: (24, 3600, 20),

    # На телефон пользователя с адресом А (из надёжной страны) выслано C
    # коротких сообщений для подтверждения телефона.
    PHONE_CONFIRMATION_SMS_PER_IP_LIMIT_COUNTER: (24, 3600, 100),
    # На телефон пользователя с адресом А (из ненадёжной страны) выслано C
    # коротких сообщений для подтверждения телефона.
    UNTRUSTED_PHONE_CONFIRMATION_SMS_PER_IP_LIMIT_COUNTER: (24, 3600, 100),

    # На телефон пользователя с адресом А (из надёжной страны) совершено C
    # звонков для подтверждения телефона.
    PHONE_CONFIRMATION_CALLS_PER_IP_LIMIT_COUNTER: (24, 3600, 5),
    # На телефон пользователя с адресом А (из ненадёжной страны) совершено C
    # звонков для подтверждения телефона.
    UNTRUSTED_PHONE_CONFIRMATION_CALLS_PER_IP_LIMIT_COUNTER: (24, 3600, 5),

    # Потребитель S выслал C коротких сообщений для подтверждения
    # телефона пользователя с адресом А.
    PHONE_CONFIRMATION_SMS_PER_IP_FOR_CONSUMER_COUNTER_FMT % 'taxi_study': (24, 3600, 2500),
    PHONE_CONFIRMATION_SMS_PER_IP_FOR_CONSUMER_COUNTER_FMT % 'taximeter': (24, 3600, 1000),
    PHONE_CONFIRMATION_SMS_PER_IP_FOR_CONSUMER_COUNTER_FMT % 'taxi-driver_protocol': (24, 3600, 1000),
    PHONE_CONFIRMATION_SMS_PER_IP_FOR_CONSUMER_COUNTER_FMT % 'taxi-driver-login': (24, 3600, 1000),
    # PASSP-27759, доставка товаров через такси
    PHONE_CONFIRMATION_SMS_PER_IP_FOR_CONSUMER_COUNTER_FMT % 'taxi-esignature-issuer': (24, 3600, 100),

    # Мобильное приложение M выслало C коротких сообщений для подтверждения
    # телефона пользователя с адресом A.
    PHONE_CONFIRMATION_SMS_PER_IP_FOR_APP_COUNTER_FMT % 'com.yandex.courier': (24, 3600, 100),

    # На почтовый адрес выслано С писем для подтверждения регистрации.
    REGISTRATION_EMAIL_PER_EMAIL_LIMIT_COUNTER: (24, 3600, 10),
    # На почтовый адрес пользователя с адресом А (из надёжной страны)
    # выслано C писем для подтверждения регистрации.
    REGISTRATION_EMAIL_PER_IP_LIMIT_COUNTER: (24, 3600, 10),
    # На почтовый адрес пользователя с адресом А (из ненадёжной страны)
    # выслано C писем для подтверждения регистрации.
    REGISTRATION_EMAIL_PER_UNTRUSTED_IP_LIMIT_COUNTER: (24, 3600, 3),

    # PASSP-4920
    # С помощью телефона зарегистрировано С пользователей пришедших с
    # адреса А (из надёжной страны).
    REGISTRATION_COMPLETED_WITH_SMS_PER_IP_LIMIT_COUNTER: (24, 3600, 100),
    # С помощью телефона зарегистрировано С пользователей пришедших с
    # адреса А (из ненадёжной страны).
    UNTRUSTED_REGISTRATION_COMPLETED_WITH_SMS_PER_IP_LIMIT_COUNTER: (24, 3600, 100),

    # смс с пробросом авторизации отправлено С раз с адреса А (из надёжной страны).
    AUTH_FORWARDING_SMS_PER_IP_LIMIT_COUNTER: (24, 3600, 100),
    # смс с пробросом авторизации отправлено С раз с адреса А (из ненадёжной страны).
    UNTRUSTED_AUTH_FORWARDING_SMS_PER_IP_LIMIT_COUNTER: (24, 3600, 100),

    # Пользователь с адресом А проверял контрольный ответ С раз.
    CHECK_ANSWER_PER_IP_LIMIT_COUNTER: (24, 3600, 500),
    # Пользователь с идентификатором И проверял контрольный ответ С раз.
    CHECK_ANSWER_PER_UID_LIMIT_COUNTER: (24, 3600, 5),
    # Пользователь с идентификатором И и адресом А проверял
    # контрольный ответ С раз.
    CHECK_ANSWER_PER_IP_AND_UID_LIMIT_COUNTER: (24, 3600, 7),

    # PASSP-4931
    # В течение принудительной смены пароля телефон с номером Н привязали С раз.
    CHANGE_PASSWORD_PER_PHONE_NUMBER_LIMIT_COUNTER: (24, 3600, 3),
    # Пользователь с адресом А принудительно менял пароль С раз.
    CHANGE_PASSWORD_PER_USER_IP_LIMIT_COUNTER: (24, 3600, 15),

    # Количество СМС, которые можно отправить на один номер в сутки
    SMS_PER_PHONE_LIMIT_COUNTER: (24, 3600, 10),

    # Количество звонков, которые можно совершить на один номер в сутки
    CALLS_PER_PHONE_LIMIT_COUNTER: (24, 3600, 5),

    # Количество СМС, которые можно отправить на один номер в сутки при регистрации
    SMS_PER_PHONE_ON_REGISTRATION_LIMIT_COUNTER: (24, 3600, 5),

    # Количество СМС, которые можно отправить с одного IP-адреса в сутки при регистрации
    REGISTRATION_SMS_SENT_PER_IP_LIMIT_COUNTER: (24, 3600, 30),

    # Количество СМС, которые можно отправить на один номер (фониш) в сутки при регистрации
    SMS_PER_PHONISH_ON_REGISTRATION_LIMIT_COUNTER: (24, 3600, 10),

    # Пользователь с адресом А отослал анкету полуавтоматического восстановления С раз
    RESTORE_SEMI_AUTO_COMPARE_PER_IP_LIMIT_COUNTER: (24, 3600, 10),
    # Пользователь с идентификатором И отослал анкету и прошел минимальный
    # набор проверок С раз
    RESTORE_SEMI_AUTO_COMPARE_PER_UID_LIMIT_COUNTER: (6, 600, 5),

    # Пользователь с адресом А в процессе восстановления получил ошибку C раз.
    RESTORE_PER_IP_LIMIT_COUNTER: (24, 3600, 10),

    # Пользователь с адресом А в процессе восстановления логина неуспешно проверил номер или ФИО C раз.
    LOGIN_RESTORE_PER_IP_LIMIT_COUNTER: (24, 3600, 20),

    # Пользователь с адресом А в процессе восстановления логина неуспешно проверил ФИО C раз.
    LOGIN_RESTORE_PER_PHONE_LIMIT_COUNTER: (24, 3600, 5),

    # PASSP-10339
    # Пользователь с адресом А прислал запрос за краткой информацией о каком-то аккаунте
    SHORT_USERINFO_COUNTER: (24, 3600, 700),

    # прирост 1млн аватар в год, в средний день загружается 115 аватар/час
    # со всех ip
    YAPIC_UPLOAD_PER_IP_LIMIT_COUNTER: (6, 600, 500),

    # за 2 минуты пользователь может загрузить 13 изображений из расчета 9 изображений в минуту
    # с учетом минимального времени ответа апи yapic 2сек.
    YAPIC_UPLOAD_PER_UID_LIMIT_COUNTER: (2, 60, 13),

    # при удалении аплоад проходит только из одного стороджа, а не из двух как при загрузке
    # => YAPIC_UPLOAD_PER_IP_LIMIT_COUNTERx2
    YAPIC_DELETE_PER_IP_LIMIT_COUNTER: (6, 600, 1000),

    # за 2 минуты пользователь может удалить 26 изображений из расчета 18 изображений в минуту
    # с учетом минимального времени ответа апи yapic 2сек.
    YAPIC_DELETE_PER_UID_LIMIT_COUNTER: (2, 60, 26),

    # Пользователь с адресом А пытался (успешно или неуспешно) Б раз пройти авторизационный челленж
    AUTH_CHALLENGE_PER_IP_LIMIT_COUNTER: (24, 3600, 100),

    # Пользователю отправлено письмо о входе с нового устройства
    AUTH_EMAIL_RECENTLY_SENT_COUNTER: (24, 3600, 1),

    # Счетчики на попытки войти по магической ссылке
    AUTH_MAGIC_LINK_EMAIL_SENT_PER_UID_COUNTER: (6, 600, 10),
    AUTH_MAGIC_LINK_EMAIL_SENT_PER_IP_COUNTER: (24, 3600, 10),
    AUTH_MAGIC_LINK_EMAIL_SENT_PER_UNTRUSTED_IP_COUNTER: (24, 3600, 3),

    # В заданный промежуток времени произошло А сбоев профиля (UFO API или модели).
    # Исходя из в среднем 400 RPS (на каждое из API), устанавливаем ограничение в 15% сбоев за 10 секунд.
    PROFILE_FAILS_COUNTER: (10, 1, 600),

    # Пользователь N раз добавил себе ключ для сброса пароля
    PASSMAN_RECOVERY_KEY_ADD_COUNTER: (24, 3600, 10),

    # Пользователь совершил N неуспешных проверок одноразового пароля
    BAD_RFC_OTP_COUNTER: (6, 600, 10),

    # Органичение регистраций Колонкишей
    REGISTRATION_KOLONKISH_PER_CREATOR_UID_SHORT_TERM: (60, 60, 50),  # 50 в час
    REGISTRATION_KOLONKISH_PER_CREATOR_UID_LONG_TERM: (24, 3600, 200),  # 200 в день

    # Ограничение на получение или регистрацию фонишей по номеру телефона
    REGISTER_PHONISH_BY_PHONE_PER_CONSUMER_COUNTER: (60, 60, 500),  # 500 в час

    # Ограничение регистрации Мейлишей
    REGISTER_MAILISH_PER_CONSUMER_COUNTER: (60, 60, 500),  # 500 в час

    # Ограничение миграции Мейлишей
    MIGRATE_MAILISH_PER_CONSUMER_COUNTER: (6, 10, 600),  # 600 в минуту (10 rps)

    # Число созданных ключей Драйва за день
    DRIVE_CREATE_DEVICE_PUBLIC_KEY_RPD_COUNTER: 20000,
    # Число созданных ключей Драйва за 5 секунд
    DRIVE_CREATE_DEVICE_PUBLIC_KEY_RPS_COUNTER: 500,

    # Число инвайтов, отправленных при помощи SMS или email за сутки
    FAMILY_INVITE_ISSUE_PER_FAMILY_COUNTER: 4,
    FAMILY_INVITE_ISSUE_PER_UID_COUNTER: 4,

    # Число отправленных пуш-уведомлений за час
    AUTH_PUSH_COUNTER: 5,

    # Число неудачных запросов к score антифрода, на которые мы реагируем и показываем челендж
    # За 10 минут
    KOLMOGOR_ANTIFRAUD_CALL_FAIL_COUNTERS_10MIN: 500000,
    # В час
    KOLMOGOR_ANTIFRAUD_CALL_FAIL_COUNTERS_1H: 1500000,
    # В сутки
    KOLMOGOR_ANTIFRAUD_CALL_FAIL_COUNTERS_24H: 2000000,

    # Число отправленных пушей с кодом для входа за час
    PUSH_2FA_COUNTER: 50,

    # Ограничение на число нотификаций по почте о смене КВКО в день
    QUESTION_CHANGE_EMAIL_NOTIFICATION_COUNTER: (24, 3600, 1),  # 1 в день

    # Количество уведомлений в день об изменениях в аккаунте
    ACCOUNT_MODIFICATION_PER_UID_COUNTER_TEMPLATE: {
        'email:app_password_add': 5,     # писем о добавлении пароля приложений
        'email:card_add': 5,             # писем о добавлении банковских карт
        'email:card_delete': 5,          # писем о удалении банковских карт
        'email:changed_password': 5,     # писем о смене пароля
        'email:email_add': 5,            # писем о добавлении email
        'email:email_delete': 5,         # писем об удалении email
        'email:hint_change': 5,          # писем о смене КВ/КО
        'email:login': 5,                # писем о входе
        'email:login_method_change': 5,  # писем о смене способа вход
        'email:social_add': 5,           # писем о добавлении соцсети
        'email:social_allow': 5,         # писем о разрешении входа через соцсеть
        'push:app_password_add': 5,      # пушей о добавлении пароля приложений
        'push:card_change': 5,           # пушей о смене банковских карт
        'push:changed_password': 5,      # пушей о смене пароля
        'push:email_change': 5,          # пушей о смене email
        'push:collector_add': 5,         # пушей о добавлении сборщика
        'push:hint_change': 5,           # пушей о смене КВ/КО
        'push:login_method_change': 5,   # пушей о смене способа входа
        'push:phone_change': 5,          # пушей о смене телефона
        'push:restore': 5,               # пушей о восстановлении доступа
        'push:social_add': 5,            # пушей о добавлении соцсети
        'push:social_allow': 5,          # пушей о разрешении входа через соцсеть
    },

    # Число отправленных email с кодом для входа за час
    EMAIL_CHECK_OWNERSHIP_SENT_COUNTER_1H: 10,

    # Число отправленных email с кодом для входа за сутки
    EMAIL_CHECK_OWNERSHIP_SENT_COUNTER_24H: 50,

    # Число показов картикок для Ключа
    YAKEY_2FA_PICTURES_SHOWN_COUNTER: 5,
}

_COUNTERS = defaultdict(lambda: dict(_DEFAULT_COUNTER_VALUES))

_COUNTERS['testing'][SOCIALREG_PER_IP_CAPTCHA_LIMIT_COUNTER] = (10, 60, 2)

_COUNTERS['testing'][REGISTRATION_EMAIL_PER_EMAIL_LIMIT_COUNTER] = (1, 3600, 10)
_COUNTERS['testing'][REGISTRATION_EMAIL_PER_IP_LIMIT_COUNTER] = (1, 3600, 40)
_COUNTERS['testing'][REGISTRATION_EMAIL_PER_UNTRUSTED_IP_LIMIT_COUNTER] = (1, 3600, 40)
_COUNTERS['development'][REGISTRATION_EMAIL_PER_EMAIL_LIMIT_COUNTER] = (1, 3600, 10)
_COUNTERS['development'][REGISTRATION_EMAIL_PER_IP_LIMIT_COUNTER] = (1, 3600, 40)
_COUNTERS['development'][REGISTRATION_EMAIL_PER_UNTRUSTED_IP_LIMIT_COUNTER] = (1, 3600, 40)

_COUNTERS['development'][PHONE_CONFIRMATION_SMS_PER_IP_LIMIT_COUNTER] = (24, 3600, 1000)
_COUNTERS['development'][PHONE_CONFIRMATION_CALLS_PER_IP_LIMIT_COUNTER] = (24, 3600, 1000)
_COUNTERS['development'][UNTRUSTED_PHONE_CONFIRMATION_SMS_PER_IP_LIMIT_COUNTER] = (24, 3600, 1000)
_COUNTERS['development'][UNTRUSTED_PHONE_CONFIRMATION_CALLS_PER_IP_LIMIT_COUNTER] = (24, 3600, 1000)
_COUNTERS['development'][AUTH_FORWARDING_SMS_PER_IP_LIMIT_COUNTER] = (24, 3600, 1000)
_COUNTERS['development'][UNTRUSTED_AUTH_FORWARDING_SMS_PER_IP_LIMIT_COUNTER] = (24, 3600, 1000)
_COUNTERS['development'][RESTORE_SEMI_AUTO_COMPARE_PER_IP_LIMIT_COUNTER] = (24, 3600, 1000)
_COUNTERS['development'][RESTORE_PER_IP_LIMIT_COUNTER] = (24, 3600, 10000)
_COUNTERS['development'][LOGIN_RESTORE_PER_IP_LIMIT_COUNTER] = (24, 3600, 1000)
_COUNTERS['development'][LOGIN_RESTORE_PER_PHONE_LIMIT_COUNTER] = (24, 3600, 100)
_COUNTERS['development'][CHECK_ANSWER_PER_UID_LIMIT_COUNTER] = (24, 3600, 15)
_COUNTERS['development'][CHECK_ANSWER_PER_IP_LIMIT_COUNTER] = (24, 3600, 1000)
_COUNTERS['development'][CALLS_PER_PHONE_LIMIT_COUNTER] = (24, 3600, 100)
_COUNTERS['development'][AUTH_MAGIC_LINK_EMAIL_SENT_PER_IP_COUNTER] = (24, 3600, 1000)

_COUNTERS['testing'][PHONE_CONFIRMATION_SMS_PER_IP_LIMIT_COUNTER] = (24, 3600, 1000)
_COUNTERS['testing'][PHONE_CONFIRMATION_CALLS_PER_IP_LIMIT_COUNTER] = (1, 3600, 100)
_COUNTERS['testing'][UNTRUSTED_PHONE_CONFIRMATION_SMS_PER_IP_LIMIT_COUNTER] = (24, 3600, 1000)
_COUNTERS['testing'][UNTRUSTED_PHONE_CONFIRMATION_CALLS_PER_IP_LIMIT_COUNTER] = (1, 3600, 100)
_COUNTERS['testing'][AUTH_FORWARDING_SMS_PER_IP_LIMIT_COUNTER] = (24, 3600, 1000)
_COUNTERS['testing'][UNTRUSTED_AUTH_FORWARDING_SMS_PER_IP_LIMIT_COUNTER] = (24, 3600, 1000)
_COUNTERS['testing'][SMS_PER_PHONE_ON_REGISTRATION_LIMIT_COUNTER] = (24, 3600, 20)
_COUNTERS['testing'][SMS_PER_PHONISH_ON_REGISTRATION_LIMIT_COUNTER] = (24, 3600, 30)
_COUNTERS['testing'][CALLS_PER_PHONE_LIMIT_COUNTER] = (1, 3600, 50)

_COUNTERS['testing'][REGISTRATION_COMPLETED_WITH_SMS_PER_IP_LIMIT_COUNTER] = (24, 3600, 10000)
_COUNTERS['testing'][REGISTRATION_SMS_SENT_PER_IP_LIMIT_COUNTER] = (24, 3600, 10000)
_COUNTERS['testing'][UNTRUSTED_REGISTRATION_COMPLETED_WITH_SMS_PER_IP_LIMIT_COUNTER] = (24, 3600, 10000)
_COUNTERS['testing'][CHECK_ANSWER_PER_UID_LIMIT_COUNTER] = (24, 3600, 10)
_COUNTERS['testing'][CHECK_ANSWER_PER_IP_LIMIT_COUNTER] = (24, 3600, 30)
_COUNTERS['testing'][RESTORE_SEMI_AUTO_COMPARE_PER_IP_LIMIT_COUNTER] = (6, 600, 50)
_COUNTERS['testing'][RESTORE_SEMI_AUTO_COMPARE_PER_UID_LIMIT_COUNTER] = (6, 600, 20)
_COUNTERS['testing'][RESTORE_PER_IP_LIMIT_COUNTER] = (24, 3600, 1000)
_COUNTERS['testing'][LOGIN_RESTORE_PER_IP_LIMIT_COUNTER] = (24, 3600, 1000)
_COUNTERS['testing'][LOGIN_RESTORE_PER_PHONE_LIMIT_COUNTER] = (24, 3600, 10)
_COUNTERS['testing'][AUTH_CHALLENGE_PER_IP_LIMIT_COUNTER] = (24, 3600, 1000000)
_COUNTERS['testing'][AUTH_MAGIC_LINK_EMAIL_SENT_PER_IP_COUNTER] = (24, 3600, 1000)

_COUNTERS['testing'][YAKEY_2FA_PICTURES_SHOWN_COUNTER] = 50

_COUNTERS['stress'][CHECK_ANSWER_PER_IP_LIMIT_COUNTER] = (24, 3600, 100000000)
_COUNTERS['stress'][CHECK_ANSWER_PER_IP_AND_UID_LIMIT_COUNTER] = (24, 3600, 100000000)

_COUNTERS['testing'][SHORT_USERINFO_COUNTER] = (6, 600, 10)
_COUNTERS['rc'][SHORT_USERINFO_COUNTER] = (6, 600, 10)

COUNTERS = _COUNTERS[yenv.type]

# Специальный лимит счетчика для восстановления по саппортской ссылке
RESTORE_PER_IP_COUNTER_LIMIT_FOR_SUPPORT_LINK = COUNTERS[RESTORE_PER_IP_LIMIT_COUNTER][2] + 10
