# -*- coding: utf-8 -*-
from copy import deepcopy

from frozendict import frozendict
import yenv

from . import secrets
from .hosts import (
    get_current_dc,
    is_plus_instance,
)
from .ssl import SSL_CA_CERT


ENV_IPV6_ONLY = yenv._load('network', '') == 'ipv6only'

# Походы в MySQL через TLS отключены в PASSP-19615
#DB_SSL_CA = SSL_CA_CERT
#DB_SSL_CIPHERS = 'kEECDH+AESGCM+AES128:kEECDH+AES128:kRSA+AESGCM+AES128:kRSA+AES128:!RC4:!aNULL:!eNULL:!MD5:!EXPORT:!LOW:!SEED:!CAMELLIA:!IDEA:!PSK:!SRP:!SSLv2'

_DB_CONFIG = {
    'other': {
        'testing': frozendict({
            'passportdbcentral': frozendict({
                'master': frozendict({
                    'host': 'cnt-dbm-test.passport.yandex.net',
                    'database': 'passportdbcentral',
                    'user': secrets.DB_USER,
                    'password': secrets.DB_PASSWORD,
                    'port': 3306,
                    'connect_timeout': 1,
                    'read_timeout': 1,
                    'write_timeout': 2,
                    'retries': 3,
                    'type': 'master',
                    'driver': 'mysql',
                }),
            }),
            'passportdbshard1': frozendict({
                'master': frozendict({
                    'host': 'cnt-dbm-test.passport.yandex.net',
                    'database': 'passportdbshard1',
                    'user': secrets.DB_USER,
                    'password': secrets.DB_PASSWORD,
                    'port': 3306,
                    'connect_timeout': 1,
                    'read_timeout': 1,
                    'write_timeout': 2,
                    'retries': 3,
                    'type': 'master',
                    'driver': 'mysql',
                }),
            }),
            'passportdbshard2': frozendict({
                'master': frozendict({
                    'host': 'cnt-dbm-test.passport.yandex.net',
                    'database': 'passportdbshard2',
                    'user': secrets.DB_USER,
                    'password': secrets.DB_PASSWORD,
                    'port': 3306,
                    'connect_timeout': 1,
                    'read_timeout': 1,
                    'write_timeout': 2,
                    'retries': 3,
                    'type': 'master',
                    'driver': 'mysql',
                }),
            }),
        }),
        'production': frozendict({
            'passportdbcentral': frozendict({
                'master': frozendict({
                    'host': 'cnt-dbm.passport.yandex.net',
                    'database': 'passportdbcentral',
                    'user': secrets.DB_USER,
                    'password': secrets.DB_PASSWORD,
                    'port': 3306,
                    'connect_timeout': 1,
                    'read_timeout': 1,
                    'write_timeout': 1,
                    'retries': 2,
                    'type': 'master',
                    'driver': 'mysql',
                }),
            }),
            'passportdbshard1': frozendict({
                'master': frozendict({
                    'host': 'sh1-dbm.passport.yandex.net',
                    'database': 'passportdbshard1',
                    'user': secrets.DB_USER,
                    'password': secrets.DB_PASSWORD,
                    'port': 3306,
                    'connect_timeout': 1,
                    'read_timeout': 1,
                    'write_timeout': 1,
                    'retries': 2,
                    'type': 'master',
                    'driver': 'mysql',
                }),
            }),
            'passportdbshard2': frozendict({
                'master': frozendict({
                    'host': 'sh1-dbm.passport.yandex.net',
                    'database': 'passportdbshard2',
                    'user': secrets.DB_USER,
                    'password': secrets.DB_PASSWORD,
                    'port': 3306,
                    'connect_timeout': 1,
                    'read_timeout': 1,
                    'write_timeout': 1,
                    'retries': 2,
                    'type': 'master',
                    'driver': 'mysql',
                }),
            }),
            'passportdbshard3': frozendict({
                'master': frozendict({
                    'host': 'sh3-dbm.passport.yandex.net',
                    'database': 'passportdbshard3',
                    'user': secrets.DB_USER,
                    'password': secrets.DB_PASSWORD,
                    'port': 3306,
                    'connect_timeout': 1,
                    'read_timeout': 1,
                    'write_timeout': 1,
                    'retries': 2,
                    'type': 'master',
                    'driver': 'mysql',
                }),
            }),
            'passportdbshard4': frozendict({
                'master': frozendict({
                    'host': 'sh3-dbm.passport.yandex.net',
                    'database': 'passportdbshard4',
                    'user': secrets.DB_USER,
                    'password': secrets.DB_PASSWORD,
                    'port': 3306,
                    'connect_timeout': 1,
                    'read_timeout': 1,
                    'write_timeout': 1,
                    'retries': 2,
                    'type': 'master',
                    'driver': 'mysql',
                }),
            }),
        }),
    },
    'stress': {
        'stress': frozendict({
            'passportdbcentral': frozendict({
                'master': frozendict({
                    'host': 'passportdb-load.passport.yandex.net',
                    'database': 'passportdbcentral',
                    'user': secrets.DB_USER,
                    'password': secrets.DB_PASSWORD,
                    'port': 3306,
                    'connect_timeout': 1,
                    'read_timeout': 1,
                    'write_timeout': 2,
                    'retries': 3,
                    'type': 'master',
                    'driver': 'mysql',
                }),
            }),
            'passportdbshard3': frozendict({
                'master': frozendict({
                    'host': 'passportdb-load.passport.yandex.net',
                    'database': 'passportdbshard3',
                    'user': secrets.DB_USER,
                    'password': secrets.DB_PASSWORD,
                    'port': 3306,
                    'connect_timeout': 1,
                    'read_timeout': 1,
                    'write_timeout': 2,
                    'retries': 3,
                    'type': 'master',
                    'driver': 'mysql',
                }),
            }),
            'passportdbshard4': frozendict({
                'master': frozendict({
                    'host': 'passportdb-load.passport.yandex.net',
                    'database': 'passportdbshard4',
                    'user': secrets.DB_USER,
                    'password': secrets.DB_PASSWORD,
                    'port': 3306,
                    'connect_timeout': 1,
                    'read_timeout': 1,
                    'write_timeout': 2,
                    'retries': 3,
                    'type': 'master',
                    'driver': 'mysql',
                }),
            }),
        }),
    },
    'intranet': {
        'development': frozendict(),
        'testing': frozendict({
            'passportdbcentral': frozendict({
                'master': frozendict({
                    'host': 'cnt-dbm-test.passport.yandex.net',
                    'database': 'passportdbcentral_yateam',
                    'user': secrets.DB_USER,
                    'password': secrets.DB_PASSWORD,
                    'port': 3306,
                    'connect_timeout': 1,
                    'read_timeout': 1,
                    'write_timeout': 2,
                    'retries': 3,
                    'type': 'master',
                    'driver': 'mysql',
                }),
            }),
            'passportdbshard1': frozendict({
                'master': frozendict({
                    'host': 'cnt-dbm-test.passport.yandex.net',
                    'database': 'passportdbshard1_yateam',
                    'user': secrets.DB_USER,
                    'password': secrets.DB_PASSWORD,
                    'port': 3306,
                    'connect_timeout': 1,
                    'read_timeout': 1,
                    'write_timeout': 2,
                    'retries': 3,
                    'type': 'master',
                    'driver': 'mysql',
                }),
            }),
        }),
        'production': frozendict({
            'passportdbcentral': frozendict({
                'master': frozendict({
                    'host': 'yateam-dbm.passport.yandex.net',
                    'database': 'passportdbcentral',
                    'user': secrets.DB_USER,
                    'password': secrets.DB_PASSWORD,
                    'port': 3306,
                    'connect_timeout': 1,
                    'read_timeout': 1,
                    'write_timeout': 2,
                    'retries': 3,
                    'type': 'master',
                    'driver': 'mysql',
                }),
            }),
            'passportdbshard1': frozendict({
                'master': frozendict({
                    'host': 'yateam-dbm.passport.yandex.net',
                    'database': 'passportdbshard1',
                    'user': secrets.DB_USER,
                    'password': secrets.DB_PASSWORD,
                    'port': 3306,
                    'connect_timeout': 1,
                    'read_timeout': 1,
                    'write_timeout': 2,
                    'retries': 3,
                    'type': 'master',
                    'driver': 'mysql',
                    #'ssl_ca': DB_SSL_CA,
                    #'ssl_ciphers': DB_SSL_CIPHERS,
                    #'ssl_verify_cert': False,
                }),
            }),
        }),
    },
}

_DB_CONFIG['other']['rc'] = _DB_CONFIG['other']['production'].copy()
_DB_CONFIG['other']['development'] = _DB_CONFIG['other']['testing'].copy()
_DB_CONFIG['intranet']['rc'] = _DB_CONFIG['intranet']['production'].copy()

_DB_CONFIG['localhost'] = deepcopy(_DB_CONFIG['other'])
DB_CONFIG = _DB_CONFIG[yenv.name][yenv.type]

current_dc = get_current_dc()
# в Финке хотим таймаут побольше
if current_dc == 'f':
    _LOW_WRITE_TIMEOUT = 0.3
else:
    _LOW_WRITE_TIMEOUT = 0.1

DB_CONFIG = frozendict({
    db_name: DB_CONFIG[db_name].copy(
        master_with_low_timeout=DB_CONFIG[db_name]['master'].copy(
            has_low_timeout=True,
            write_timeout=_LOW_WRITE_TIMEOUT,
            retries=1,
        ),
    ) for db_name in DB_CONFIG
})

if is_plus_instance():
    # У плюсовых машин очень много gunicorn-воркеров, а БД им не нужна. Сэкономим кучу коннектов к БД.
    DB_CONFIG = {}

PING_DB_NAMES = DB_CONFIG.keys()

PREPARE_CONNECTION_ATTEMPTS = 1  # 0 чтобы не пытаться вообще
