# -*- coding: utf-8 -*-
from collections import namedtuple

import yenv

from .tlds import PASSPORT_TLDS


domain_keyspace = namedtuple('domain_keyspace', ['domain', 'keyspace'])
if yenv.name == 'intranet':
    _DOMAIN_KEYSPACES = (
        ('yandex-team.ru', 'yandex-team.ru'),
    )
else:
    _DOMAIN_KEYSPACES = (
        tuple(('yandex.%s' % tld, 'yandex.%s' % tld) for tld in PASSPORT_TLDS) +
        (
            ('kinopoisk.ru', 'kinopoisk.ru'),
            ('bringly.ru', 'bringly.ru'),
            ('edadeal.ru', 'edadeal.ru'),
            ('edastage.ru', 'edastage.ru'),
            ('yandexsport.ru', 'yandexsport.ru'),
            ('toloka.ai', 'toloka.ai'),
            ('yandex.delivery', 'yandex.delivery'),
            ('yango.delivery', 'yango.delivery'),
            ('yango.com', 'yango.com'),
            ('practicum.com', 'practicum.com'),
            ('ya.ru', 'ya.ru'),
        )
    )
    if yenv.type == 'testing':
        _DOMAIN_KEYSPACES += (
            ('k50dev.ru', 'k50dev.ru'),
            ('k50wldev.ru', 'k50wldev.ru'),
            ('toloka-test.ai', 'toloka-test.ai'),
        )
    else:
        _DOMAIN_KEYSPACES += (
            ('auto.ru', 'auto.ru'),
            ('avto.ru', 'avto.ru'),
            ('k50.ru', 'k50.ru'),
            ('dzen.ru', 'dzen.ru'),
        )

DOMAIN_KEYSPACES = [domain_keyspace(i, j) for i, j in _DOMAIN_KEYSPACES]


_PASSPORT_SUBDOMAINS = {
    'intranet': {
        'testing': 'passport-test',
        'rc': 'passport-rc',
        'production': 'passport',
    },
    'stress': {
        'stress': 'passport-load',
    },
    'localhost': {
        'development': 'passportdev',
        'testing': 'passport-test',
        'rc': 'passport-rc',
        'production': 'passport',
    },
}
PASSPORT_SUBDOMAIN = _PASSPORT_SUBDOMAINS[yenv.name][yenv.type]
