# -*- coding: utf-8 -*-
from collections import namedtuple

from .tlds import PASSPORT_TLDS


email_domains = namedtuple('email_domains', ['domain', 'email_domain'])
_DEFAULT_EMAIL_DOMAINS = tuple(
    ('yandex.%s' % tld, 'yandex.%s' % tld)
    if tld != 'com.tr'
    else ('yandex.%s' % tld, 'yandex.com')
    for tld in PASSPORT_TLDS
)

DEFAULT_EMAIL_DOMAIN = 'yandex.com'

DEFAULT_EMAIL_DOMAINS = tuple(email_domains(i, j) for i, j in _DEFAULT_EMAIL_DOMAINS)

NATIVE_EMAIL_DOMAINS = tuple('yandex.%s' % tld for tld in PASSPORT_TLDS) + (
    'narod.ru',
    'ya.ru',
    u'яндекс.рф',
)
