# -*- coding: utf-8 -*-
from passport.backend.api.settings.constants.common import TIMESTAMP_DELTA_ONE_DAY
import yenv


# Профиль включен только в большом Паспорте
AUTH_PROFILE_ENABLED = yenv.name == 'localhost'

# Требование челленджа выключено в тестинге (кроме специальных пользователей)
AUTH_PROFILE_CHALLENGE_ENABLED = yenv.type not in {'development', 'testing'}

# Порог достоверности fresh-профиля, превышение которого приведет к принудительному показу челленджа
WEB_PROFILE_DISTANCE_THRESHOLD = 55
MOBILE_PROFILE_DISTANCE_THRESHOLD = 100
# Период (секунды с момента регистрации), в течение которого челлендж не показываем
PROFILE_TRIAL_PERIOD = 10 * TIMESTAMP_DELTA_ONE_DAY

ALLOW_PROFILE_CHECK_FOR_MOBILE = False
ALLOW_PROFILE_CHECK_FOR_WEB = False
