# -*- coding: utf-8 -*-

import yenv


_FEDERAL_CONFIGS_API_URLS = {
    'localhost': {
        'development': 'https://federal-cfg-api-test.passport.yandex.net',
        'testing': 'https://federal-cfg-api-test.passport.yandex.net',
        'rc': 'https://federal-cfg-api.passport.yandex.net',
        'production': 'https://federal-cfg-api.passport.yandex.net',
    },
}

if yenv.name == 'localhost':
    FEDERAL_CONFIGS_API_URL = _FEDERAL_CONFIGS_API_URLS[yenv.name][yenv.type]
else:
    FEDERAL_CONFIGS_API_URL = ''

FEDERAL_CONFIGS_API_NAMESPACE = '360'

FEDERAL_CONFIGS_API_TIMEOUT = 0.2
FEDERAL_CONFIGS_API_RETRIES = 2
