# -*- coding: utf-8 -*-
import yenv

from . import secrets


_FRODO_URLS = {
    'other': {
        'development': 'http://frodo-testing.so.yandex-team.ru:8080/',
        'testing': 'http://frodo-testing.so.yandex-team.ru:8080/',
        'rc': 'http://frodo.so.yandex-team.ru:8080/',
        'production': 'http://frodo.so.yandex-team.ru:8080/',
    },
    'stress': {
        'stress': 'http://passport-fake-services.passport-load.passport.yandex.net/frodo/',
    },
    'intranet': {
        'development': '',
    },
}

_FRODO_URLS['intranet']['production'] = _FRODO_URLS['intranet']['rc'] = _FRODO_URLS['intranet']['testing'] = _FRODO_URLS['intranet']['development']

_FRODO_URLS['localhost'] = _FRODO_URLS['other']

FRODO_URL = _FRODO_URLS[yenv.name][yenv.type]

# максимальное время ожидания ответа ФРОДО
FRODO_TIMEOUT = 1

# число попыток получить ответ от ФРОДО
FRODO_RETRIES = 2

# salt для хэширования телефона по md5 перед отправкой в ФО
# хранить в секрете от самой ФО
FRODO_SECRET_SALT = secrets.FRODO_SALT

FRODO_DUMMY_IP = 'FEC0:1111:2222:3333:4444:5555:6666:7777'
