# -*- coding: utf-8 -*-
from frozendict import frozendict
import yenv

from .language import DISPLAY_LANGUAGES


_DEFAULT_HINT_QUESTION_IDS = map(str, [0] + list(range(12, 15)) + [4, 3] + list(range(15, 19)) + [99])

# Если для носителей какого-либо языка есть недопустимые вопросы, то для этого
# языка нужно специально определить список допустимых вопросов.
HINT_QUESTION_IDS_FOR_LANGUAGES = {}
for lang in DISPLAY_LANGUAGES:
    HINT_QUESTION_IDS_FOR_LANGUAGES[lang] = _DEFAULT_HINT_QUESTION_IDS

HINT_QUESTION_IDS_FOR_LANGUAGES = frozendict(HINT_QUESTION_IDS_FOR_LANGUAGES)

DONT_SHOW_HINT_IF_SECURE_NUMBER_AVAILABLE = yenv.type in ('development', 'testing', 'rc', 'production')
